/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.keyrotation.impl.services;

import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccess;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStorePersistence;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import java.security.KeyStore;
import javax.inject.Inject;

public class KeyStoreAccessImpl
implements KeyStoreAccess {
    private final KeyStorePersistence persistence;
    private final Juggler juggler;
    private final KeyRotationConfig config;

    @Inject
    public KeyStoreAccessImpl(KeyStorePersistence persistence, Juggler juggler, KeyRotationConfig config) {
        this.persistence = persistence;
        this.juggler = juggler;
        this.config = config;
    }

    @Override
    public KeyStore read() {
        if (null == this.persistence.read()) {
            return null;
        }
        return this.juggler.serializeDeserialize().deserialize(this.persistence.read(), this.config.keyStorePassword());
    }

    @Override
    public void write(KeyStore keyStore) {
        this.persistence.write(this.juggler.serializeDeserialize().serialize(keyStore, this.config.keyStorePassword()));
    }
}

