/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.keyrotation.impl.services;

import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.generated.Encrypting;
import de.adorsys.keymanagement.api.types.template.generated.Secret;
import de.adorsys.keymanagement.api.types.template.generated.Signing;
import de.adorsys.keymanagement.keyrotation.api.services.KeyGenerator;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import de.adorsys.keymanagement.keyrotation.api.types.KeyState;
import de.adorsys.keymanagement.keyrotation.api.types.KeyStatus;
import de.adorsys.keymanagement.keyrotation.api.types.KeyType;
import java.time.Instant;
import java.util.UUID;
import javax.inject.Inject;

public class KeyGeneratorImpl
implements KeyGenerator {
    private final Juggler juggler;
    private final KeyRotationConfig config;

    @Inject
    public KeyGeneratorImpl(Juggler juggler, KeyRotationConfig config) {
        this.juggler = juggler;
        this.config = config;
    }

    @Override
    public ProvidedKeyTemplate generateValidKey(Instant now, KeyType forType) {
        if (forType == KeyType.SECRET) {
            return this.juggler.generateKeys().secret(((Secret)this.config.getKeyTemplate().get((Object)forType)).toBuilder().keyTemplate((KeyTemplate)new NameAndPassword(UUID.randomUUID().toString(), this.config.keyPassword())).metadata((KeyMetadata)this.stateForValidKey(now, forType)).build());
        }
        if (forType == KeyType.SIGNING) {
            return this.juggler.generateKeys().signing(((Signing)this.config.getKeyTemplate().get((Object)forType)).toBuilder().keyTemplate((KeyTemplate)new NameAndPassword(UUID.randomUUID().toString(), this.config.keyPassword())).metadata((KeyMetadata)this.stateForValidKey(now, forType)).build());
        }
        if (forType == KeyType.ENCRYPTING) {
            return this.juggler.generateKeys().encrypting(((Encrypting)this.config.getKeyTemplate().get((Object)forType)).toBuilder().keyTemplate((KeyTemplate)new NameAndPassword(UUID.randomUUID().toString(), this.config.keyPassword())).metadata((KeyMetadata)this.stateForValidKey(now, forType)).build());
        }
        throw new IllegalArgumentException("Unknown generator for key type: " + forType.name());
    }

    private KeyState stateForValidKey(Instant now, KeyType type) {
        return KeyState.builder().status(KeyStatus.VALID).type(type).createdAt(now).notAfter(now.plus(this.config.getValidity())).expireAt(now.plus(this.config.getLegacy())).build();
    }
}

