package de.adorsys.keymanagement.keyrotation.impl.services;

import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccess;
import de.adorsys.keymanagement.keyrotation.api.persistence.RotationLocker;
import de.adorsys.keymanagement.keyrotation.api.services.KeyGenerator;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import java.time.Clock;
import javax.annotation.processing.Generated;
import javax.inject.Provider;

@ScopeMetadata
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class RotationImpl_Factory implements Factory<RotationImpl> {
  private final Provider<KeyGenerator> generatorProvider;

  private final Provider<KeyRotationConfig> configProvider;

  private final Provider<Juggler> jugglerProvider;

  private final Provider<Clock> timeSourceProvider;

  private final Provider<KeyStoreAccess> accessProvider;

  private final Provider<RotationLocker> lockerProvider;

  public RotationImpl_Factory(Provider<KeyGenerator> generatorProvider,
      Provider<KeyRotationConfig> configProvider, Provider<Juggler> jugglerProvider,
      Provider<Clock> timeSourceProvider, Provider<KeyStoreAccess> accessProvider,
      Provider<RotationLocker> lockerProvider) {
    this.generatorProvider = generatorProvider;
    this.configProvider = configProvider;
    this.jugglerProvider = jugglerProvider;
    this.timeSourceProvider = timeSourceProvider;
    this.accessProvider = accessProvider;
    this.lockerProvider = lockerProvider;
  }

  @Override
  public RotationImpl get() {
    return newInstance(generatorProvider.get(), configProvider.get(), jugglerProvider.get(), timeSourceProvider.get(), accessProvider.get(), lockerProvider.get());
  }

  public static RotationImpl_Factory create(Provider<KeyGenerator> generatorProvider,
      Provider<KeyRotationConfig> configProvider, Provider<Juggler> jugglerProvider,
      Provider<Clock> timeSourceProvider, Provider<KeyStoreAccess> accessProvider,
      Provider<RotationLocker> lockerProvider) {
    return new RotationImpl_Factory(generatorProvider, configProvider, jugglerProvider, timeSourceProvider, accessProvider, lockerProvider);
  }

  public static RotationImpl newInstance(KeyGenerator generator, KeyRotationConfig config,
      Juggler juggler, Clock timeSource, KeyStoreAccess access, RotationLocker locker) {
    return new RotationImpl(generator, config, juggler, timeSource, access, locker);
  }
}
