package de.adorsys.keymanagement.keyrotation.services;

import dagger.internal.DaggerGenerated;
import dagger.internal.Preconditions;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.KeyStoreManager;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccess;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStoreAccessDelegate;
import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStorePersistence;
import de.adorsys.keymanagement.keyrotation.api.persistence.RotationLocker;
import de.adorsys.keymanagement.keyrotation.api.services.KeyView;
import de.adorsys.keymanagement.keyrotation.api.services.Rotation;
import de.adorsys.keymanagement.keyrotation.api.types.KeyRotationConfig;
import de.adorsys.keymanagement.keyrotation.impl.services.KeyGeneratorImpl;
import de.adorsys.keymanagement.keyrotation.impl.services.KeyStoreAccessImpl;
import de.adorsys.keymanagement.keyrotation.impl.services.KeyViewImpl;
import de.adorsys.keymanagement.keyrotation.impl.services.RotationImpl;
import de.adorsys.keymanagement.keyrotation.modules.KeyStoreAccessModule_AccessCaptorFactory;
import de.adorsys.keymanagement.keyrotation.modules.RotationModule_KeyStoreManagementFactory;
import java.time.Clock;
import javax.annotation.processing.Generated;

@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class DaggerRotatedKeyStore {
  private DaggerRotatedKeyStore() {
  }

  public static RotatedKeyStore.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements RotatedKeyStore.Builder {
    private KeyStoreConfig keyStoreConfig;

    private KeyStoreManager keyStoreManager;

    private Clock timeSource;

    private KeyStoreAccessDelegate accessDelegate;

    private KeyStorePersistence persistence;

    private RotationLocker distributedLock;

    private KeyRotationConfig rotationConfig;

    @Override
    public Builder keyStoreConfig(KeyStoreConfig manager) {
      this.keyStoreConfig = manager;
      return this;
    }

    @Override
    public Builder keyStoreManager(KeyStoreManager manager) {
      this.keyStoreManager = manager;
      return this;
    }

    @Override
    public Builder timeSource(Clock timeSource) {
      this.timeSource = timeSource;
      return this;
    }

    @Override
    public Builder accessDelegate(KeyStoreAccessDelegate callCaptor) {
      this.accessDelegate = callCaptor;
      return this;
    }

    @Override
    public Builder persistence(KeyStorePersistence persistence) {
      this.persistence = Preconditions.checkNotNull(persistence);
      return this;
    }

    @Override
    public Builder distributedLock(RotationLocker locker) {
      this.distributedLock = Preconditions.checkNotNull(locker);
      return this;
    }

    @Override
    public Builder rotationConfig(KeyRotationConfig config) {
      this.rotationConfig = Preconditions.checkNotNull(config);
      return this;
    }

    @Override
    public RotatedKeyStore build() {
      Preconditions.checkBuilderRequirement(persistence, KeyStorePersistence.class);
      Preconditions.checkBuilderRequirement(distributedLock, RotationLocker.class);
      Preconditions.checkBuilderRequirement(rotationConfig, KeyRotationConfig.class);
      return new RotatedKeyStoreImpl(keyStoreConfig, keyStoreManager, timeSource, accessDelegate, persistence, distributedLock, rotationConfig);
    }
  }

  private static final class RotatedKeyStoreImpl implements RotatedKeyStore {
    private final KeyStoreManager keyStoreManager;

    private final KeyStoreConfig keyStoreConfig;

    private final KeyRotationConfig rotationConfig;

    private final Clock timeSource;

    private final KeyStoreAccessDelegate accessDelegate;

    private final KeyStorePersistence persistence;

    private final RotationLocker distributedLock;

    private final RotatedKeyStoreImpl rotatedKeyStoreImpl = this;

    private RotatedKeyStoreImpl(KeyStoreConfig keyStoreConfigParam,
        KeyStoreManager keyStoreManagerParam, Clock timeSourceParam,
        KeyStoreAccessDelegate accessDelegateParam, KeyStorePersistence persistenceParam,
        RotationLocker distributedLockParam, KeyRotationConfig rotationConfigParam) {
      this.keyStoreManager = keyStoreManagerParam;
      this.keyStoreConfig = keyStoreConfigParam;
      this.rotationConfig = rotationConfigParam;
      this.timeSource = timeSourceParam;
      this.accessDelegate = accessDelegateParam;
      this.persistence = persistenceParam;
      this.distributedLock = distributedLockParam;

    }

    private Juggler juggler() {
      return RotationModule_KeyStoreManagementFactory.keyStoreManagement(keyStoreManager, keyStoreConfig);
    }

    private KeyGeneratorImpl keyGeneratorImpl() {
      return new KeyGeneratorImpl(juggler(), rotationConfig);
    }

    private KeyStoreAccessImpl keyStoreAccessImpl() {
      return new KeyStoreAccessImpl(persistence, juggler(), rotationConfig);
    }

    private KeyStoreAccess keyStoreAccess() {
      return KeyStoreAccessModule_AccessCaptorFactory.accessCaptor(accessDelegate, keyStoreAccessImpl());
    }

    private RotationImpl rotationImpl() {
      return new RotationImpl(keyGeneratorImpl(), rotationConfig, juggler(), timeSource, keyStoreAccess(), distributedLock);
    }

    private KeyViewImpl keyViewImpl() {
      return new KeyViewImpl(rotationConfig, keyStoreAccess(), juggler());
    }

    @Override
    public Rotation forRotation() {
      return rotationImpl();
    }

    @Override
    public KeyView keys() {
      return keyViewImpl();
    }
  }
}
