package de.adorsys.keymanagement.juggler.services;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import de.adorsys.keymanagement.adapter.modules.keystore.KeyStoreModule_KeyStoreConfigFactory;
import de.adorsys.keymanagement.api.generator.KeyGenerator;
import de.adorsys.keymanagement.api.metadata.KeyMetadataOper;
import de.adorsys.keymanagement.api.metadata.KeyMetadataPersistence;
import de.adorsys.keymanagement.api.persist.KeyStoreCreator;
import de.adorsys.keymanagement.api.persist.SerDe;
import de.adorsys.keymanagement.api.source.KeyDecoder;
import de.adorsys.keymanagement.api.source.KeyReader;
import de.adorsys.keymanagement.bouncycastle.adapter.services.decode.DefaultDecoderImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.decode.DefaultDecoderImpl_Factory;
import de.adorsys.keymanagement.bouncycastle.adapter.services.generator.DefaultEncryptingKeyGeneratorImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.generator.DefaultSecretKeyGeneratorImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.generator.DefaultSecretKeyGeneratorImpl_Factory;
import de.adorsys.keymanagement.bouncycastle.adapter.services.generator.DefaultSigningKeyGeneratorImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.persist.DefaultKeyStoreOperImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.serde.DefaultKeyStoreSerde;
import de.adorsys.keymanagement.core.generator.TemplateMappingGeneratorImpl;
import de.adorsys.keymanagement.core.metadata.MetadataPersistenceConfig;
import de.adorsys.keymanagement.core.metadata.ToKeyStoreMetadataPersister;
import de.adorsys.keymanagement.core.metadata.ToKeyStoreMetadataPersister_Factory;
import de.adorsys.keymanagement.core.source.DefaultKeyReaderImpl;
import de.adorsys.keymanagement.juggler.modules.metadata.MetadataModule;
import de.adorsys.keymanagement.juggler.modules.metadata.MetadataModule_MetadataOperFactory;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerBCJuggler implements BCJuggler {
  private final MetadataPersistenceConfig metadataConfig;

  private final KeyMetadataPersistence metadataPersister;

  private final MetadataModule metadataModule;

  private Provider<MetadataPersistenceConfig> metadataConfigProvider;

  private Provider<ToKeyStoreMetadataPersister> toKeyStoreMetadataPersisterProvider;

  private DaggerBCJuggler(MetadataModule metadataModuleParam,
      MetadataPersistenceConfig metadataConfigParam,
      KeyMetadataPersistence metadataPersisterParam) {
    this.metadataConfig = metadataConfigParam;
    this.metadataPersister = metadataPersisterParam;
    this.metadataModule = metadataModuleParam;
    initialize(metadataModuleParam, metadataConfigParam, metadataPersisterParam);
  }

  public static BCJuggler.Builder builder() {
    return new Builder();
  }

  private TemplateMappingGeneratorImpl getTemplateMappingGeneratorImpl() {
    return new TemplateMappingGeneratorImpl(new DefaultEncryptingKeyGeneratorImpl(), new DefaultSecretKeyGeneratorImpl(), new DefaultSigningKeyGeneratorImpl());}

  private KeyMetadataOper getKeyMetadataOper() {
    return MetadataModule_MetadataOperFactory.metadataOper(metadataModule, metadataConfig, metadataPersister, DoubleCheck.lazy(toKeyStoreMetadataPersisterProvider));}

  private DefaultKeyStoreOperImpl getDefaultKeyStoreOperImpl() {
    return new DefaultKeyStoreOperImpl(getKeyMetadataOper());}

  private DefaultKeyReaderImpl getDefaultKeyReaderImpl() {
    return new DefaultKeyReaderImpl(getDefaultKeyStoreOperImpl(), getKeyMetadataOper());}

  private DefaultKeyStoreSerde getDefaultKeyStoreSerde() {
    return new DefaultKeyStoreSerde(KeyStoreModule_KeyStoreConfigFactory.keyStoreConfig());}

  @SuppressWarnings("unchecked")
  private void initialize(final MetadataModule metadataModuleParam,
      final MetadataPersistenceConfig metadataConfigParam,
      final KeyMetadataPersistence metadataPersisterParam) {
    this.metadataConfigProvider = InstanceFactory.createNullable(metadataConfigParam);
    this.toKeyStoreMetadataPersisterProvider = ToKeyStoreMetadataPersister_Factory.create(metadataConfigProvider, (Provider) DefaultSecretKeyGeneratorImpl_Factory.create(), (Provider) DefaultDecoderImpl_Factory.create());
  }

  @Override
  public KeyGenerator generateKeys() {
    return getTemplateMappingGeneratorImpl();}

  @Override
  public KeyStoreCreator toKeystore() {
    return getDefaultKeyStoreOperImpl();}

  @Override
  public KeyReader readKeys() {
    return getDefaultKeyReaderImpl();}

  @Override
  public KeyDecoder decode() {
    return new DefaultDecoderImpl();}

  @Override
  public SerDe serializeDeserialize() {
    return getDefaultKeyStoreSerde();}

  private static final class Builder implements BCJuggler.Builder {
    private MetadataPersistenceConfig metadataConfig;

    private KeyMetadataPersistence metadataPersister;

    @Override
    public Builder metadataConfig(MetadataPersistenceConfig config) {
      this.metadataConfig = config;
      return this;
    }

    @Override
    public Builder metadataPersister(KeyMetadataPersistence persistence) {
      this.metadataPersister = persistence;
      return this;
    }

    @Override
    public BCJuggler build() {
      return new DaggerBCJuggler(new MetadataModule(), metadataConfig, metadataPersister);
    }
  }
}
