/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.keyrotation.jdbc;

import de.adorsys.keymanagement.keyrotation.api.persistence.KeyStorePersistence;
import de.adorsys.keymanagement.keyrotation.api.persistence.RotationLocker;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import lombok.Generated;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import net.javacrumbs.shedlock.provider.jdbc.JdbcLockProvider;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;

public class JdbcRotationManager
implements KeyStorePersistence,
RotationLocker {
    private static final int LOCK_DURATION = 5;
    private final String keyStoreId;
    private final LockProvider lockProvider;
    private final DataSource dataSource;
    private final String keyStoreTableName;
    private final LockingTaskExecutor executor;
    private final Duration lockAtMost;

    public JdbcRotationManager(String keyStoreId, DataSource dataSource, String lockTableName, String keyStoreTableName, Duration lockAtMost) {
        this.keyStoreId = keyStoreId;
        this.lockProvider = new JdbcLockProvider(dataSource, lockTableName);
        this.executor = new DefaultLockingTaskExecutor(this.lockProvider);
        this.dataSource = dataSource;
        this.keyStoreTableName = keyStoreTableName;
        this.lockAtMost = lockAtMost;
    }

    public JdbcRotationManager(String keyStoreId, DataSource dataSource, LockProvider lockProvider, String keyStoreTableName, Duration lockAtMost) {
        this.keyStoreId = keyStoreId;
        this.lockProvider = lockProvider;
        this.executor = new DefaultLockingTaskExecutor(lockProvider);
        this.dataSource = dataSource;
        this.keyStoreTableName = keyStoreTableName;
        this.lockAtMost = lockAtMost;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Table name is unbindable and is trusted code-provided")
    public byte[] read() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Table name is unbindable and is trusted code-provided")
    public void write(byte[] keyStore) {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement("UPDATE " + this.keyStoreTableName + " SET keystore = ? WHERE id = ?");){
            conn.setAutoCommit(false);
            this.setKeyStore(1, keyStore, stmt);
            stmt.setString(2, this.keyStoreId);
            int cnt = stmt.executeUpdate();
            if (0 == cnt) {
                this.doInsert(conn, keyStore);
            }
            conn.commit();
        }
    }

    public void executeWithLock(Runnable runnable) {
        this.executor.executeWithLock(runnable, new LockConfiguration(Instant.now(), this.keyStoreId, this.lockAtMost, Duration.of(5L, ChronoUnit.MILLIS)));
    }

    public void clearCache() {
        if (this.lockProvider instanceof StorageBasedLockProvider) {
            ((StorageBasedLockProvider)this.lockProvider).clearCache();
        }
    }

    private void setKeyStore(int pos, byte[] keyStore, PreparedStatement stmt) throws SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(keyStore);
        stmt.setBinaryStream(pos, (InputStream)is, is.available());
    }

    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Table name is unbindable and is trusted code-provided")
    private void doInsert(Connection conn, byte[] keyStore) throws SQLException {
        try (PreparedStatement insert = conn.prepareStatement("INSERT INTO " + this.keyStoreTableName + " (id, keystore) VALUES (?, ?)");){
            insert.setString(1, this.keyStoreId);
            this.setKeyStore(2, keyStore, insert);
            insert.executeUpdate();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyStoreId() {
        return this.keyStoreId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LockProvider getLockProvider() {
        return this.lockProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyStoreTableName() {
        return this.keyStoreTableName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LockingTaskExecutor getExecutor() {
        return this.executor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getLockAtMost() {
        return this.lockAtMost;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JdbcRotationManager(String keyStoreId, LockProvider lockProvider, DataSource dataSource, String keyStoreTableName, LockingTaskExecutor executor, Duration lockAtMost) {
        this.keyStoreId = keyStoreId;
        this.lockProvider = lockProvider;
        this.dataSource = dataSource;
        this.keyStoreTableName = keyStoreTableName;
        this.executor = executor;
        this.lockAtMost = lockAtMost;
    }
}

