/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.bouncycastle.adapter.services.generator;

import de.adorsys.keymanagement.api.generator.SecretKeyGenerator;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.generated.Pbe;
import de.adorsys.keymanagement.api.types.template.generated.Secret;
import de.adorsys.keymanagement.api.types.template.provided.ProvidedKey;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.SecretKeyBuilder;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.inject.Inject;

public class DefaultSecretKeyGeneratorImpl
implements SecretKeyGenerator {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final Provider provider;

    @Inject
    public DefaultSecretKeyGeneratorImpl(Provider provider) {
        this.provider = provider;
    }

    public ProvidedKey generate(Pbe fromTemplate) {
        return ProvidedKey.builder().keyTemplate((KeyTemplate)fromTemplate).metadata(fromTemplate.getMetadata()).key((Key)this.generateSecret(fromTemplate)).build();
    }

    public ProvidedKey generateRaw(Pbe fromTemplate) {
        return ProvidedKey.builder().keyTemplate((KeyTemplate)fromTemplate).metadata(fromTemplate.getMetadata()).key((Key)this.generateRawSecret(fromTemplate)).build();
    }

    public ProvidedKey generate(Secret fromTemplate) {
        return ProvidedKey.builder().keyTemplate((KeyTemplate)fromTemplate).metadata(fromTemplate.getMetadata()).key((Key)this.generateSecret(fromTemplate)).build();
    }

    private SecretKey generateSecret(Secret secret) {
        return new SecretKeyBuilder().withProvider(this.provider).withKeyAlg(secret.getAlgo()).withKeyLength(secret.getSize()).build();
    }

    private SecretKey generateSecret(Pbe secret) {
        byte[] salt = new byte[secret.getSaltLen()];
        SECURE_RANDOM.nextBytes(salt);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(secret.getData(), salt, secret.getIterCount());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(secret.getAlgo(), this.provider);
        return keyFac.generateSecret(pbeKeySpec);
    }

    private SecretKey generateRawSecret(Pbe secret) {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(secret.getData());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(secret.getAlgo(), this.provider);
        return keyFac.generateSecret(pbeKeySpec);
    }
}

