/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator;

import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.BatchValidator;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.CaSignedCertificateBuilder;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.KeyValue;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.ListOfKeyValueBuilder;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.types.SelfSignedKeyPairData;
import java.security.KeyPair;
import java.security.Provider;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;

public class SingleKeyUsageSelfSignedCertBuilder {
    private Provider provider;
    private String signatureAlgo;
    private Integer notAfterInDays;
    private Integer notBeforeInDays = 0;
    private X500Name subjectDN;
    private boolean ca;
    private int[] keyUsages;
    boolean dirty = false;

    public SelfSignedKeyPairData build(KeyPair keyPair) {
        if (this.dirty) {
            throw new IllegalStateException("Builder can not be reused");
        }
        this.dirty = true;
        List<KeyValue> notNullCheckList = ListOfKeyValueBuilder.newBuilder().add("provider", this.provider).add("subjectDN", this.subjectDN).add("signatureAlgo", this.signatureAlgo).add("notBeforeInDays", this.notBeforeInDays).add("notAfterInDays", this.notAfterInDays).add("keyPair", keyPair).build();
        List<String> nullList = BatchValidator.filterNull(notNullCheckList);
        if (nullList != null && !nullList.isEmpty()) {
            throw new IllegalArgumentException("Fields can not be null: " + nullList);
        }
        CaSignedCertificateBuilder builder = new CaSignedCertificateBuilder().withProvider(this.provider).withCa(this.ca).withNotBeforeInDays(this.notBeforeInDays).withNotAfterInDays(this.notAfterInDays).withSubjectDN(this.subjectDN).withSubjectPublicKey(keyPair.getPublic());
        if (this.keyUsages != null) {
            for (int keyUsage : this.keyUsages) {
                builder = builder.withKeyUsage(keyUsage);
            }
        }
        X509CertificateHolder subjectCert = builder.build(keyPair.getPrivate());
        return new SelfSignedKeyPairData(keyPair, subjectCert);
    }

    public SingleKeyUsageSelfSignedCertBuilder withProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public SingleKeyUsageSelfSignedCertBuilder withSubjectDN(X500Name subjectDN) {
        this.subjectDN = subjectDN;
        return this;
    }

    public SingleKeyUsageSelfSignedCertBuilder withSignatureAlgo(String signatureAlgo) {
        this.signatureAlgo = signatureAlgo;
        return this;
    }

    public SingleKeyUsageSelfSignedCertBuilder withNotAfterInDays(Integer notAfterInDays) {
        this.notAfterInDays = notAfterInDays;
        return this;
    }

    public SingleKeyUsageSelfSignedCertBuilder withNotBeforeInDays(Integer notBeforeInDays) {
        this.notBeforeInDays = notBeforeInDays;
        return this;
    }

    public SingleKeyUsageSelfSignedCertBuilder withCa(boolean ca) {
        this.ca = ca;
        return this;
    }

    public SingleKeyUsageSelfSignedCertBuilder withKeyUsages(int[] keyUsages) {
        this.keyUsages = keyUsages;
        return this;
    }
}

