/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator;

import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.KeyPairBuilder;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.KeyPairData;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.SingleKeyUsageSelfSignedCertBuilder;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.types.SelfSignedKeyPairData;
import java.security.KeyPair;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class KeyPairGenerator {
    private static final int[] keyUsageSignature = new int[]{64};
    private static final int[] keyUsageEncryption = new int[]{32, 16, 8};
    private final String keyAlgo;
    private final int keySize;
    private final String serverSigAlgo;
    private final String serverKeyPairName;
    private final int daysAfter;
    private final boolean withCA;

    public KeyPairData generateSignatureKey() {
        return this.generate(keyUsageSignature);
    }

    public KeyPairData generateEncryptionKey() {
        return this.generate(keyUsageEncryption);
    }

    private KeyPairData generate(int[] keyUsages) {
        KeyPair keyPair = new KeyPairBuilder().withKeyAlg(this.keyAlgo).withKeyLength(this.keySize).build();
        X500Name dn = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, this.serverKeyPairName).build();
        SelfSignedKeyPairData keyPairData = new SingleKeyUsageSelfSignedCertBuilder().withSubjectDN(dn).withSignatureAlgo(this.serverSigAlgo).withNotAfterInDays(this.daysAfter).withCa(this.withCA).withKeyUsages(keyUsages).build(keyPair);
        return KeyPairData.builder().keyPair(keyPairData).build();
    }

    private static int $default$daysAfter() {
        return 900;
    }

    private static boolean $default$withCA() {
        return false;
    }

    KeyPairGenerator(String keyAlgo, int keySize, String serverSigAlgo, String serverKeyPairName, int daysAfter, boolean withCA) {
        this.keyAlgo = keyAlgo;
        this.keySize = keySize;
        this.serverSigAlgo = serverSigAlgo;
        this.serverKeyPairName = serverKeyPairName;
        this.daysAfter = daysAfter;
        this.withCA = withCA;
    }

    public static KeyPairGeneratorBuilder builder() {
        return new KeyPairGeneratorBuilder();
    }

    public static class KeyPairGeneratorBuilder {
        private String keyAlgo;
        private int keySize;
        private String serverSigAlgo;
        private String serverKeyPairName;
        private boolean daysAfter$set;
        private int daysAfter$value;
        private boolean withCA$set;
        private boolean withCA$value;

        KeyPairGeneratorBuilder() {
        }

        public KeyPairGeneratorBuilder keyAlgo(String keyAlgo) {
            this.keyAlgo = keyAlgo;
            return this;
        }

        public KeyPairGeneratorBuilder keySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public KeyPairGeneratorBuilder serverSigAlgo(String serverSigAlgo) {
            this.serverSigAlgo = serverSigAlgo;
            return this;
        }

        public KeyPairGeneratorBuilder serverKeyPairName(String serverKeyPairName) {
            this.serverKeyPairName = serverKeyPairName;
            return this;
        }

        public KeyPairGeneratorBuilder daysAfter(int daysAfter) {
            this.daysAfter$value = daysAfter;
            this.daysAfter$set = true;
            return this;
        }

        public KeyPairGeneratorBuilder withCA(boolean withCA) {
            this.withCA$value = withCA;
            this.withCA$set = true;
            return this;
        }

        public KeyPairGenerator build() {
            int daysAfter$value = this.daysAfter$value;
            if (!this.daysAfter$set) {
                daysAfter$value = KeyPairGenerator.$default$daysAfter();
            }
            boolean withCA$value = this.withCA$value;
            if (!this.withCA$set) {
                withCA$value = KeyPairGenerator.$default$withCA();
            }
            return new KeyPairGenerator(this.keyAlgo, this.keySize, this.serverSigAlgo, this.serverKeyPairName, daysAfter$value, withCA$value);
        }

        public String toString() {
            return "KeyPairGenerator.KeyPairGeneratorBuilder(keyAlgo=" + this.keyAlgo + ", keySize=" + this.keySize + ", serverSigAlgo=" + this.serverSigAlgo + ", serverKeyPairName=" + this.serverKeyPairName + ", daysAfter$value=" + this.daysAfter$value + ", withCA$value=" + this.withCA$value + ")";
        }
    }
}

