/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator;

import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.BatchValidator;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.KeyValue;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.ListOfKeyValueBuilder;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.ProviderUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class KeyPairBuilder {
    private Integer keyLength;
    private String keyAlg;
    boolean dirty = false;

    public KeyPair build() {
        KeyPairGenerator kGen;
        if (this.dirty) {
            throw new IllegalStateException("Builder can not be reused");
        }
        this.dirty = true;
        List<KeyValue> notNullCheckList = ListOfKeyValueBuilder.newBuilder().add("keyAlg", this.keyAlg).add("keyLength", this.keyLength).build();
        List<String> nullList = BatchValidator.filterNull(notNullCheckList);
        if (nullList != null && !nullList.isEmpty()) {
            throw new IllegalArgumentException("Fields can not be null: " + nullList);
        }
        try {
            kGen = KeyPairGenerator.getInstance(this.keyAlg, ProviderUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        kGen.initialize(this.keyLength);
        return kGen.generateKeyPair();
    }

    public KeyPairBuilder withKeyLength(Integer keyLength) {
        this.keyLength = keyLength;
        return this;
    }

    public KeyPairBuilder withKeyAlg(String keyAlg) {
        this.keyAlg = keyAlg;
        return this;
    }
}

