/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.bouncycastle.adapter.services.serde;

import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import de.adorsys.keymanagement.api.persist.SerDe;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class DefaultKeyStoreSerde
implements SerDe {
    private final Provider provider;
    private final KeyStoreConfig config;

    @Inject
    public DefaultKeyStoreSerde(Provider provider, @Nullable KeyStoreConfig config) {
        this.provider = provider;
        this.config = null == config ? KeyStoreConfig.builder().build() : config;
    }

    public DefaultKeyStoreSerde withConfig(KeyStoreConfig config) {
        return new DefaultKeyStoreSerde(this.provider, config);
    }

    public byte[] serialize(KeyStore keyStore, Supplier<char[]> keyStorePassword) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        keyStore.store(os, keyStorePassword.get());
        return os.toByteArray();
    }

    public KeyStore deserialize(byte[] keyStore, Supplier<char[]> keyStorePassword) {
        KeyStore ks = KeyStore.getInstance(this.config.getType(), this.provider);
        ks.load(new ByteArrayInputStream(keyStore), keyStorePassword.get());
        return ks;
    }
}

