/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator;

import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.BatchValidator;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.KeyValue;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.ListOfKeyValueBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SecretKeyBuilder {
    private Provider provider;
    private Integer keyLength;
    private String keyAlg;
    boolean dirty = false;

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public SecretKey build() {
        KeyGenerator kGen;
        if (this.dirty) {
            throw new IllegalStateException("Builder can not be reused");
        }
        this.dirty = true;
        List<KeyValue> notNullCheckList = ListOfKeyValueBuilder.newBuilder().add("provider", this.provider).add("keyAlg", this.keyAlg).add("keyLength", this.keyLength).build();
        List<String> nullList = BatchValidator.filterNull(notNullCheckList);
        if (nullList != null && !nullList.isEmpty()) {
            throw new IllegalArgumentException("Fields can not be null: " + nullList);
        }
        try {
            kGen = KeyGenerator.getInstance(this.keyAlg, this.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        kGen.init(this.keyLength);
        return kGen.generateKey();
    }

    public SecretKeyBuilder withProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public SecretKeyBuilder withKeyLength(Integer keyLength) {
        this.keyLength = keyLength;
        return this;
    }

    public SecretKeyBuilder withKeyAlg(String keyAlg) {
        this.keyAlg = keyAlg;
        return this;
    }
}

