/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator;

import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.BatchValidator;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.KeyValue;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.ListOfKeyValueBuilder;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.SerialNumberGenerator;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.V3CertificateUtils;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;

public class CaSignedCertificateBuilder {
    private Provider provider;
    private boolean createCaCert;
    private X500Name subjectDN;
    private Integer notAfterInDays;
    private Integer notBeforeInDays = 0;
    private int keyUsage = -1;
    private boolean keyUsageSet = false;
    private String signatureAlgo;
    private PublicKey subjectPublicKey;
    boolean dirty = false;

    public X509CertificateHolder build(PrivateKey issuerPrivatekey) {
        if (this.dirty) {
            throw new IllegalStateException("Builder can not be reused");
        }
        this.dirty = true;
        this.signatureAlgo = this.autodetectAlgorithm(issuerPrivatekey);
        Instant now = Instant.now();
        Date notAfter = this.notAfterInDays != null ? Date.from(now.plus((long)this.notAfterInDays.intValue(), ChronoUnit.DAYS)) : null;
        Date notBefore = this.notBeforeInDays != null ? Date.from(now.plus((long)this.notBeforeInDays.intValue(), ChronoUnit.DAYS)) : null;
        List<KeyValue> notNullCheckList = ListOfKeyValueBuilder.newBuilder().add("provider", this.provider).add("X509CertificateBuilder_missing_subject_DN", this.subjectDN).add("X509CertificateBuilder_missing_subject_publicKey", this.subjectPublicKey).add("X509CertificateBuilder_missing_validity_date_notBefore", notBefore).add("X509CertificateBuilder_missing_validity_date_notAfter", notAfter).build();
        List<String> errorKeys = BatchValidator.filterNull(notNullCheckList);
        if (errorKeys != null && !errorKeys.isEmpty()) {
            throw new IllegalArgumentException("Fields can not be null: " + errorKeys);
        }
        X500Name issuerDN = null;
        BasicConstraints basicConstraints = null;
        issuerDN = this.subjectDN;
        basicConstraints = this.createCaCert ? new BasicConstraints(true) : new BasicConstraints(false);
        BigInteger serial = SerialNumberGenerator.uniqueSerial();
        JcaX509v3CertificateBuilder v3CertGen = new JcaX509v3CertificateBuilder(issuerDN, serial, notBefore, notAfter, this.subjectDN, this.subjectPublicKey);
        JcaX509ExtensionUtils extUtils = V3CertificateUtils.getJcaX509ExtensionUtils();
        v3CertGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)basicConstraints);
        v3CertGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(this.subjectPublicKey));
        v3CertGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(this.subjectPublicKey));
        if (this.keyUsageSet) {
            v3CertGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(this.keyUsage));
        }
        ContentSigner signer = V3CertificateUtils.getContentSigner(this.provider, issuerPrivatekey, this.signatureAlgo);
        return v3CertGen.build(signer);
    }

    private String autodetectAlgorithm(PrivateKey issuerPrivatekey) {
        if (null == this.signatureAlgo || this.signatureAlgo.isEmpty()) {
            String algorithm = issuerPrivatekey.getAlgorithm();
            if (null == algorithm) {
                return null;
            }
            if ("DSA".equals(algorithm.toUpperCase(Locale.US))) {
                return "SHA256withDSA";
            }
            if ("RSA".equals(algorithm.toUpperCase(Locale.US))) {
                return "SHA256WithRSA";
            }
            return null;
        }
        return this.signatureAlgo;
    }

    public CaSignedCertificateBuilder withProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public CaSignedCertificateBuilder withCa(boolean ca) {
        this.createCaCert = ca;
        return this;
    }

    public CaSignedCertificateBuilder withSubjectDN(X500Name subjectDN) {
        this.subjectDN = subjectDN;
        return this;
    }

    public CaSignedCertificateBuilder withSubjectPublicKey(PublicKey subjectPublicKey) {
        this.subjectPublicKey = subjectPublicKey;
        return this;
    }

    public CaSignedCertificateBuilder withNotAfterInDays(Integer notAfterInDays) {
        this.notAfterInDays = notAfterInDays;
        return this;
    }

    public CaSignedCertificateBuilder withNotBeforeInDays(Integer notBeforeInDays) {
        this.notBeforeInDays = notBeforeInDays;
        return this;
    }

    public CaSignedCertificateBuilder withKeyUsage(int keyUsage) {
        if (this.keyUsageSet) {
            this.keyUsage |= keyUsage;
        } else {
            this.keyUsage = keyUsage;
            this.keyUsageSet = true;
        }
        return this;
    }
}

