/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloack.secret.mapper;

import de.adorsys.keycloack.secret.adapter.common.SecretAndAudiencesModel;
import de.adorsys.keycloack.secret.adapter.common.UserSecretAdapter;
import de.adorsys.keycloack.secret.mapper.AuthenticatorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;

public class STSClaimMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper {
    private static final String STS_USER_SECRET_CLAIM_NAME = "STS_USER_SECRET_CLAIM_NAME";
    private static final String PROVIDER_ID = "user-secret-claim-mapper";
    private static final List<ProviderConfigProperty> PROVIDER_CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();
    private UserSecretAdapter userSecretAdapter;
    private String claimName;

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public void postInit(KeycloakSessionFactory factory) {
        super.postInit(factory);
        this.claimName = Optional.ofNullable(System.getenv(STS_USER_SECRET_CLAIM_NAME)).orElseGet(() -> System.getProperty(STS_USER_SECRET_CLAIM_NAME, "user-secret"));
        this.userSecretAdapter = (UserSecretAdapter)factory.getProviderFactory(UserSecretAdapter.class).create(null);
    }

    public String getDisplayType() {
        return "User Attribute";
    }

    public String getHelpText() {
        return "Put user secret into access token under the name specified by STS_USER_SECRET_CLAIM_NAME";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return PROVIDER_CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AccessToken accessToken = super.transformAccessToken(token, mappingModel, session, userSession, clientSessionCtx);
        SecretAndAudiencesModel secretAndAudModel = AuthenticatorUtil.readSecretAndAud(this.userSecretAdapter, userSession);
        Map retrieveResourceSecrets = this.userSecretAdapter.retrieveResourceSecrets(secretAndAudModel, userSession.getRealm(), userSession.getUser());
        if (retrieveResourceSecrets != null && !retrieveResourceSecrets.isEmpty()) {
            accessToken.getOtherClaims().put(this.claimName, retrieveResourceSecrets);
        }
        return accessToken;
    }
}

