/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloack.secret.mapper;

import de.adorsys.keycloack.secret.adapter.common.SecretAndAudiencesModel;
import de.adorsys.keycloack.secret.adapter.common.UserSecretAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.keycloak.models.UserSessionModel;

public class AuthenticatorUtil {
    private static final String STS_DEFAULT_AUDIENCE = "STS_DEFAULT_AUDIENCE";
    private static String defaultAudience = Optional.ofNullable(System.getenv("STS_DEFAULT_AUDIENCE")).orElseGet(() -> System.getProperty(STS_DEFAULT_AUDIENCE));

    private static List<String> extractAudiences(String scope) {
        List audiences = Optional.ofNullable(scope).map(Object::toString).map(s -> s.split(" ")).map(Arrays::asList).orElse(new ArrayList());
        return audiences.stream().filter(a -> !"openid".equals(a)).collect(Collectors.toList());
    }

    public static SecretAndAudiencesModel readSecretAndAud(UserSecretAdapter userSecretStorage, UserSessionModel userSession) {
        String userMainSecret = userSession.getNote("UserSecretStorage-UserMainSecret");
        String scope = userSession.getNote("UserSecretStorage-AuthSessionScope");
        List<String> audiences = AuthenticatorUtil.extractAudiences(scope);
        if (audiences.size() == 0 && defaultAudience != null) {
            audiences.add(defaultAudience);
        }
        return new SecretAndAudiencesModel(userMainSecret, audiences);
    }

    public static String getEnvOrSysProp(String propName, boolean optional) {
        String propValue = System.getenv(propName);
        if (StringUtils.isBlank((String)propValue)) {
            propValue = System.getProperty(propName);
        }
        if (StringUtils.isBlank((String)propValue)) {
            if (optional) {
                return null;
            }
            throw new IllegalStateException("Missing Environmen property " + propName);
        }
        return propValue;
    }
}

