/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloack.secret.mapper;

import de.adorsys.keycloack.secret.adapter.common.SecretAndAudModel;
import de.adorsys.keycloack.secret.adapter.common.UserSecretAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.models.UserSessionModel;

public class AuthenticatorUtil {
    private static List<String> extractAudiences(String scope) {
        List audiences = Optional.ofNullable(scope).map(Object::toString).map(s -> s.split(" ")).map(Arrays::asList).orElse(new ArrayList());
        return audiences.stream().filter(a -> !"openid".equals(a)).collect(Collectors.toList());
    }

    public static SecretAndAudModel readSecretAndAud(UserSecretAdapter userSecretStorage, UserSessionModel userSession) {
        String userMainSecret = userSession.getNote("UserSecretStorage-UserMainSecret");
        String scope = userSession.getNote("UserSecretStorage-AuthSessionScope");
        List<String> audiences = AuthenticatorUtil.extractAudiences(scope);
        return new SecretAndAudModel(userMainSecret, audiences);
    }
}

