/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloack.custom.auth;

import de.adorsys.keycloack.custom.auth.STSUsernamePasswordForm;
import de.adorsys.keycloack.secret.adapter.common.UserSecretAdapter;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.authenticators.browser.UsernamePasswordForm;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class STSUsernamePasswordFormFactory
implements AuthenticatorFactory {
    private static final String PROVIDER_ID = "sts-username-password-form";
    private UsernamePasswordForm singleton;
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED};

    public Authenticator create(KeycloakSession session) {
        return this.singleton;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        UserSecretAdapter userSecretAdapter = (UserSecretAdapter)factory.getProviderFactory(UserSecretAdapter.class).create(null);
        this.singleton = new STSUsernamePasswordForm(userSecretAdapter);
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getReferenceCategory() {
        return "password";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getDisplayType() {
        return "Custom Username Password Form";
    }

    public String getHelpText() {
        return "Validates a username and password from login form.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }
}

