/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloack.custom.auth;

import de.adorsys.keycloack.custom.auth.AuthenticatorUtil;
import de.adorsys.keycloack.secret.adapter.common.UserSecretAdapter;
import java.util.LinkedList;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.browser.UsernamePasswordForm;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;

public class STSUsernamePasswordForm
extends UsernamePasswordForm {
    private UserSecretAdapter userSecretAdapter;

    public STSUsernamePasswordForm(UserSecretAdapter userSecretAdapter) {
        this.userSecretAdapter = userSecretAdapter;
    }

    public boolean validatePassword(AuthenticationFlowContext context, UserModel user, MultivaluedMap<String, String> inputData) {
        LinkedList<PasswordUserCredentialModel> credentials = new LinkedList<PasswordUserCredentialModel>();
        String password = (String)inputData.getFirst((Object)"password");
        PasswordUserCredentialModel credentialModel = UserCredentialModel.password((String)password);
        Optional<String> scope = AuthenticatorUtil.readScope(context);
        scope.ifPresent(s -> credentialModel.setNote("SCOPE", s));
        credentials.add(credentialModel);
        if (password != null && !password.isEmpty() && context.getSession().userCredentialManager().isValid(context.getRealm(), user, credentials)) {
            AuthenticatorUtil.addMainSecretToUserSession(this.userSecretAdapter, context, user, (UserCredentialModel)credentialModel);
            return true;
        }
        context.getEvent().user(user);
        context.getEvent().error("invalid_user_credentials");
        Response challengeResponse = this.invalidCredentials(context);
        context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challengeResponse);
        context.clearUser();
        return false;
    }
}

