/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloack.custom.auth;

import de.adorsys.keycloack.secret.adapter.common.UserSecretAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class AuthenticatorUtil {
    public static Optional<String> readScope(AuthenticationFlowContext context) {
        String scope = context.getAuthenticationSession().getClientNote("scope");
        return Optional.ofNullable(scope).map(Object::toString);
    }

    public static List<String> extractAudiences(UserCredentialModel credentialInput) {
        Object scope = credentialInput.getNote("SCOPE");
        List audiences = Optional.ofNullable(scope).map(Object::toString).map(s -> s.split(" ")).map(Arrays::asList).orElse(new ArrayList());
        return audiences.stream().filter(a -> !"openid".equals(a)).collect(Collectors.toList());
    }

    public static void addMainSecretToUserSession(UserSecretAdapter userSecretStorage, AuthenticationFlowContext context, UserModel user, UserCredentialModel credentialModel) {
        String userSecret = userSecretStorage.retrieveMainSecret(context.getRealm(), user, credentialModel);
        Object scope = credentialModel.getNote("SCOPE");
        if (userSecret != null) {
            context.getAuthenticationSession().setUserSessionNote("UserSecretStorage-UserMainSecret", userSecret);
        }
        if (scope != null) {
            context.getAuthenticationSession().setUserSessionNote("UserSecretStorage-AuthSessionScope", scope.toString());
        }
    }
}

