/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloack.custom.auth;

import de.adorsys.keycloack.custom.auth.AuthenticatorUtil;
import de.adorsys.keycloack.secret.adapter.common.UserSecretAdapter;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.directgrant.ValidatePassword;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;

public class STSDirectAccessAuthenticator
extends ValidatePassword {
    private static final String PROVIDER_ID = "sts-direct-access-authenticator";
    private UserSecretAdapter userSecretAdapter;

    public void postInit(KeycloakSessionFactory factory) {
        super.postInit(factory);
        this.userSecretAdapter = (UserSecretAdapter)factory.getProviderFactory(UserSecretAdapter.class).create(null);
    }

    public String getDisplayType() {
        return "Custom Validate Password";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession session) {
        return this;
    }

    public void authenticate(AuthenticationFlowContext context) {
        UserCredentialModel credentialModel = this.passwordAndScope(context);
        boolean valid = context.getSession().userCredentialManager().isValid(context.getRealm(), context.getUser(), new CredentialInput[]{credentialModel});
        if (!valid) {
            context.getEvent().user(context.getUser());
            context.getEvent().error("invalid_user_credentials");
            Response challengeResponse = this.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_grant", "Invalid user credentials");
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
        } else {
            AuthenticatorUtil.addMainSecretToUserSession(this.userSecretAdapter, context, context.getUser(), credentialModel);
            context.success();
        }
    }

    private UserCredentialModel passwordAndScope(AuthenticationFlowContext context) {
        String password = this.retrievePassword(context);
        PasswordUserCredentialModel credentialModel = UserCredentialModel.password((String)password);
        Optional<String> scope = AuthenticatorUtil.readScope(context);
        scope.ifPresent(arg_0 -> STSDirectAccessAuthenticator.lambda$passwordAndScope$0((UserCredentialModel)credentialModel, arg_0));
        return credentialModel;
    }

    private static /* synthetic */ void lambda$passwordAndScope$0(UserCredentialModel credentialModel, String s) {
        credentialModel.setNote("SCOPE", s);
    }
}

