/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloak.extension.clientregistration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.keycloak.extension.clientregistration.OIDCClientRepresentationExtended;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientregistration.ClientRegistrationException;
import org.keycloak.services.clientregistration.oidc.DescriptionConverter;

class DescriptionConverterExt {
    DescriptionConverterExt() {
    }

    static ClientRepresentation toInternal(KeycloakSession session, OIDCClientRepresentationExtended clientOIDCext) throws ClientRegistrationException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("software_statement", clientOIDCext.getSoftwareStatement());
        ClientRepresentation client = DescriptionConverter.toInternal((KeycloakSession)session, (OIDCClientRepresentation)clientOIDCext);
        client.setAttributes(attributes);
        return client;
    }

    static OIDCClientRepresentationExtended toExternalResponse(KeycloakSession session, ClientRepresentation client, URI uri) {
        String softStatement = (String)client.getAttributes().get("software_statement");
        OIDCClientRepresentation clientRep = DescriptionConverter.toExternalResponse((KeycloakSession)session, (ClientRepresentation)client, (URI)uri);
        OIDCClientRepresentationExtended response = new OIDCClientRepresentationExtended();
        ObjectMapper mapper = new ObjectMapper();
        try {
            String clientRepStr = mapper.writeValueAsString(clientRep);
            response = mapper.readValue(clientRepStr, OIDCClientRepresentationExtended.class);
            response.setSoftwareStatement(softStatement);
            return response;
        }
        catch (IOException e) {
            ServicesLogger.LOGGER.warn("Failed to convert ClientRepresentation to OIDCClientRepresentationExtended. Exception: {}", (Object)e.getMessage(), (Throwable)e);
            return response;
        }
    }
}

