/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keycloak.extension.clientregistration;

import de.adorsys.keycloak.extension.clientregistration.DescriptionConverterExt;
import de.adorsys.keycloak.extension.clientregistration.OIDCClientRepresentationExtended;
import de.adorsys.keycloak.extension.clientregistration.SSAService;
import java.net.URI;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.oidc.mappers.PairwiseSubMapperHelper;
import org.keycloak.protocol.oidc.mappers.SHA256PairwiseSubMapper;
import org.keycloak.protocol.oidc.utils.SubjectType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientregistration.AbstractClientRegistrationProvider;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationException;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.oidc.OIDCClientRegistrationContext;

public class OIDCClientRegistrationExtendedProvider
extends AbstractClientRegistrationProvider {
    OIDCClientRegistrationExtendedProvider(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createOIDC(OIDCClientRepresentationExtended clientOIDC) {
        if (clientOIDC.getClientId() != null) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier included", Response.Status.BAD_REQUEST);
        }
        try {
            SSAService.validate(clientOIDC);
            ClientRepresentation client = DescriptionConverterExt.toInternal(this.session, clientOIDC);
            OIDCClientRegistrationContext oidcContext = new OIDCClientRegistrationContext(this.session, client, (ClientRegistrationProvider)this, (OIDCClientRepresentation)clientOIDC);
            client = this.create((ClientRegistrationContext)oidcContext);
            ClientModel clientModel = this.session.getContext().getRealm().getClientByClientId(client.getClientId());
            this.updatePairwiseSubMappers(clientModel, SubjectType.parse((String)clientOIDC.getSubjectType()), clientOIDC.getSectorIdentifierUri());
            this.updateClientRepWithProtocolMappers(clientModel, client);
            URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(client.getClientId()).build(new Object[0]);
            OIDCClientRepresentationExtended clientOIDCResponse = DescriptionConverterExt.toExternalResponse(this.session, client, uri);
            clientOIDCResponse.setClientIdIssuedAt(Time.currentTime());
            return Response.created((URI)uri).entity((Object)clientOIDCResponse).build();
        }
        catch (ClientRegistrationException cre) {
            ServicesLogger.LOGGER.clientRegistrationException(cre.getMessage());
            throw new ErrorResponseException("invalid_client_metadata", "Client metadata invalid", Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public Response getOIDC(@PathParam(value="clientId") String clientId) {
        ClientRepresentation client = this.get(clientId);
        OIDCClientRepresentationExtended clientOIDC = DescriptionConverterExt.toExternalResponse(this.session, client, this.session.getContext().getUri().getRequestUri());
        return Response.ok((Object)((Object)clientOIDC)).build();
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateOIDC(@PathParam(value="clientId") String clientId, OIDCClientRepresentationExtended clientOIDC) {
        try {
            ClientRepresentation client = DescriptionConverterExt.toInternal(this.session, clientOIDC);
            OIDCClientRegistrationContext oidcContext = new OIDCClientRegistrationContext(this.session, client, (ClientRegistrationProvider)this, (OIDCClientRepresentation)clientOIDC);
            client = this.update(clientId, (ClientRegistrationContext)oidcContext);
            ClientModel clientModel = this.session.getContext().getRealm().getClientByClientId(client.getClientId());
            this.updatePairwiseSubMappers(clientModel, SubjectType.parse((String)clientOIDC.getSubjectType()), clientOIDC.getSectorIdentifierUri());
            this.updateClientRepWithProtocolMappers(clientModel, client);
            URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(client.getClientId()).build(new Object[0]);
            OIDCClientRepresentationExtended clientOIDCResponse = DescriptionConverterExt.toExternalResponse(this.session, client, uri);
            return Response.ok((Object)((Object)clientOIDCResponse)).build();
        }
        catch (ClientRegistrationException cre) {
            ServicesLogger.LOGGER.clientRegistrationException(cre.getMessage());
            throw new ErrorResponseException("invalid_client_metadata", "Client metadata invalid", Response.Status.BAD_REQUEST);
        }
    }

    @DELETE
    @Path(value="{clientId}")
    public void deleteOIDC(@PathParam(value="clientId") String clientId) {
        this.delete(clientId);
    }

    private void updatePairwiseSubMappers(ClientModel clientModel, SubjectType subjectType, String sectorIdentifierUri) {
        Set protocolMappers = clientModel.getProtocolMappers();
        if (subjectType == SubjectType.PAIRWISE) {
            AtomicBoolean foundPairwise = new AtomicBoolean(false);
            for (ProtocolMapperModel mapping : protocolMappers) {
                if (!mapping.getProtocolMapper().endsWith("-pairwise-sub-mapper")) continue;
                foundPairwise.set(true);
                PairwiseSubMapperHelper.setSectorIdentifierUri((ProtocolMapperModel)mapping, (String)sectorIdentifierUri);
                clientModel.updateProtocolMapper(mapping);
            }
            if (!foundPairwise.get()) {
                ProtocolMapperRepresentation newPairwise = SHA256PairwiseSubMapper.createPairwiseMapper((String)sectorIdentifierUri, null);
                clientModel.addProtocolMapper(RepresentationToModel.toModel((ProtocolMapperRepresentation)newPairwise));
            }
        } else {
            for (ProtocolMapperModel mapping : protocolMappers) {
                if (!mapping.getProtocolMapper().endsWith("-pairwise-sub-mapper")) continue;
                protocolMappers.remove(mapping);
            }
        }
    }

    private void updateClientRepWithProtocolMappers(ClientModel clientModel, ClientRepresentation rep) {
        LinkedList<ProtocolMapperRepresentation> mappings = new LinkedList<ProtocolMapperRepresentation>();
        for (ProtocolMapperModel model : clientModel.getProtocolMappers()) {
            mappings.add(ModelToRepresentation.toRepresentation((ProtocolMapperModel)model));
        }
        rep.setProtocolMappers(mappings);
    }
}

