/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBCIExecStatus {
    private static final Logger log = LoggerFactory.getLogger(HBCIExecStatus.class);
    private List<HBCIMsgStatus> msgStatusList;
    private ArrayList<Exception> exceptions = new ArrayList();

    public void addException(Exception e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(e);
        log.error(e.getMessage(), (Throwable)e);
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public List<String> getErrorMessages() {
        ArrayList<String> ret = new ArrayList<String>();
        List<Exception> exc = this.getExceptions();
        if (exc != null && !exc.isEmpty()) {
            for (Exception e : exc) {
                ret.add(HBCIUtils.exception2StringShort(e));
            }
        }
        if (this.msgStatusList != null) {
            this.msgStatusList.forEach(hbciMsgStatus -> ret.addAll(hbciMsgStatus.getErrorList()));
        }
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        String linesep = System.getProperty("line.separator");
        List<Exception> exc = this.getExceptions();
        if (exc != null) {
            for (Exception e : exc) {
                ret.append(HBCIUtils.exception2StringShort(e));
                ret.append(linesep);
            }
        }
        if (this.msgStatusList != null) {
            for (int i = 0; i < this.msgStatusList.size(); ++i) {
                ret.append(HBCIUtils.getLocMsg("STAT_MSG")).append(" #").append(i + 1).append(":").append(System.getProperty("line.separator"));
                ret.append(this.msgStatusList.get(i).toString());
                ret.append(System.getProperty("line.separator"));
            }
        }
        return ret.toString().trim();
    }

    public boolean isOK() {
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            return false;
        }
        boolean ret = true;
        if (this.msgStatusList != null) {
            for (HBCIMsgStatus hbciMsgStatus : this.msgStatusList) {
                ret &= hbciMsgStatus.isOK();
            }
        }
        return ret;
    }

    public List<HBCIMsgStatus> getMsgStatusList() {
        return this.msgStatusList;
    }

    public void setMsgStatusList(List<HBCIMsgStatus> msgStatusList) {
        this.msgStatusList = msgStatusList;
    }
}

