/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.HashMap;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBCIUpdDialog
extends AbstractHbciDialog {
    private static final Logger log = LoggerFactory.getLogger(HBCIUpdDialog.class);

    public HBCIUpdDialog(PinTanPassport passport) {
        super(passport);
    }

    @Override
    public HBCIExecStatus execute(boolean close) {
        if (this.passport.getUPD() == null) {
            try {
                log.debug("registering user");
                this.updateUserData();
                if (close) {
                    this.close();
                }
            }
            catch (Exception ex) {
                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANT_REG_USER"), ex);
            }
        }
        return null;
    }

    @Override
    public long getMsgnum() {
        return 2L;
    }

    private void fetchSysId() {
        HBCIMsgStatus syncStatus = null;
        try {
            this.passport.getCallback().status(9, null);
            log.info("fetching new sys-id from institute");
            this.passport.setSigId(1L);
            this.passport.setSysId("0");
            syncStatus = this.doDialogInitSync("Synch", "0");
            if (!syncStatus.isOK()) {
                throw new ProcessException(HBCIUtils.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), syncStatus);
            }
            this.passport.updateUPD(syncStatus.getData());
            this.passport.setSysId(syncStatus.getData().get("SyncRes.sysid"));
            this.passport.getCallback().status(10, new Object[]{syncStatus, this.passport.getSysId()});
            log.debug("new sys-id is " + this.passport.getSysId());
            this.dialogId = syncStatus.getData().get("MsgHead.dialogid");
            if (syncStatus != null) {
                this.passport.postInitResponseHook(syncStatus);
            }
        }
        catch (Exception e) {
            try {
                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SYNCSYSIDFAIL"), e);
            }
            catch (Throwable throwable) {
                if (syncStatus != null) {
                    this.passport.postInitResponseHook(syncStatus);
                }
                throw throwable;
            }
        }
    }

    private void fetchSigId() {
        HBCIMsgStatus msgStatus = null;
        try {
            this.passport.getCallback().status(15, null);
            log.info("syncing signature id");
            this.passport.setSigId(9999999999999999L);
            msgStatus = this.doDialogInitSync("Synch", "2");
            if (!msgStatus.isOK()) {
                throw new ProcessException(HBCIUtils.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), msgStatus);
            }
            HashMap<String, String> syncResult = msgStatus.getData();
            this.passport.updateUPD(syncResult);
            this.passport.setSigId(syncResult.get("SyncRes.sigid") != null ? Long.valueOf(syncResult.get("SyncRes.sigid")) : 1L);
            this.passport.incSigId();
            this.passport.getCallback().status(16, new Object[]{msgStatus, this.passport.getSigId()});
            log.debug("signature id set to " + this.passport.getSigId());
            this.dialogId = syncResult.get("MsgHead.dialogid");
            if (msgStatus != null) {
                this.passport.postInitResponseHook(msgStatus);
            }
        }
        catch (Exception e) {
            try {
                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SYNCSIGIDFAIL"), e);
            }
            catch (Throwable throwable) {
                if (msgStatus != null) {
                    this.passport.postInitResponseHook(msgStatus);
                }
                throw throwable;
            }
        }
    }

    private void fetchUPD() {
        try {
            this.passport.getCallback().status(11, null);
            log.info("fetching UPD (BPD-Version: " + this.passport.getBPDVersion() + ")");
            HBCIMsgStatus msgStatus = this.doDialogInitSync("DialogInit", null);
            if (!msgStatus.isOK()) {
                throw new ProcessException(HBCIUtils.getLocMsg("EXCMSG_GETUPDFAIL"), msgStatus);
            }
            HashMap<String, String> result = msgStatus.getData();
            this.passport.postInitResponseHook(msgStatus);
            this.passport.updateUPD(result);
            this.dialogId = result.get("MsgHead.dialogid");
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_GETUPDFAIL"), e);
        }
    }

    private HBCIMsgStatus doDialogInitSync(String messageName, String syncMode) {
        Message message = MessageFactory.createDialogInit(messageName, syncMode, this.passport, true, "HKIDN");
        return this.kernel.rawDoIt(message, true, true);
    }

    private void updateUserData() {
        if (this.passport.getSysStatus().equals("1")) {
            if (this.passport.getSysId().equals("0")) {
                this.fetchSysId();
            }
            if (this.passport.getSigId() == -1L) {
                this.fetchSigId();
            }
        }
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }
}

