/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIMessage;
import org.kapott.hbci.manager.HBCIMessageQueue;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBCIJobsDialog
extends AbstractHbciDialog {
    private static final Logger log = LoggerFactory.getLogger(HBCIJobsDialog.class);
    private HBCIMessageQueue queue = new HBCIMessageQueue();
    private HashMap<String, Integer> listOfGVs = new HashMap();

    public HBCIJobsDialog(PinTanPassport passport) {
        this(passport, null, -1L);
    }

    public HBCIJobsDialog(PinTanPassport passport, String dialogId, long msgnum) {
        super(passport);
        this.dialogId = dialogId;
        this.msgnum = msgnum;
    }

    public HBCIMessage addTask(AbstractHBCIJob job) {
        return this.addTask(job, true);
    }

    public HBCIMessage addTask(AbstractHBCIJob job, boolean verify) {
        try {
            String hbciCode;
            log.info(HBCIUtils.getLocMsg("EXCMSG_ADDJOB", job.getName()));
            if (verify) {
                job.verifyConstraints();
            }
            if ((hbciCode = job.getHBCICode()) == null) {
                throw new HBCI_Exception(job.getName() + " not supported");
            }
            int gva_counter = this.listOfGVs.size();
            Integer counter_st = this.listOfGVs.get(hbciCode);
            int gv_counter = counter_st != null ? counter_st : 0;
            int total_counter = this.getTotalNumberOfGVSegsInCurrentMessage();
            ++gv_counter;
            ++total_counter;
            if (counter_st == null) {
                ++gva_counter;
            }
            int maxGVA = this.passport.getMaxGVperMsg();
            int maxGVSegJob = job.getMaxNumberPerMsg();
            int maxGVSegTotal = this.passport.getMaxGVSegsPerMsg();
            if (maxGVA > 0 && gva_counter > maxGVA || maxGVSegJob > 0 && gv_counter > maxGVSegJob || maxGVSegTotal > 0 && total_counter > maxGVSegTotal) {
                if (maxGVSegTotal > 0 && total_counter > maxGVSegTotal) {
                    log.debug("have to generate new message because current type of passport only allows " + maxGVSegTotal + " GV segs per message");
                } else {
                    log.debug("have to generate new message because of BPD restrictions for number of tasks per message; adding job to this new message");
                }
                this.newMsg();
                gv_counter = 1;
            }
            this.listOfGVs.put(hbciCode, gv_counter);
            HBCIMessage last = this.queue.getLast();
            last.append(job);
            return last;
        }
        catch (Exception e) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_CANTADDJOB", job.getName());
            log.error("task " + job.getName() + " will not be executed in current dialog");
            throw new HBCI_Exception(msg, e);
        }
    }

    private int getTotalNumberOfGVSegsInCurrentMessage() {
        int total = 0;
        for (Map.Entry<String, Integer> hbciCode : this.listOfGVs.entrySet()) {
            total += hbciCode.getValue().intValue();
        }
        log.debug("there are currently " + total + " GV segs in this message");
        return total;
    }

    private void newMsg() {
        log.debug("starting new message");
        this.queue.append(new HBCIMessage());
        this.listOfGVs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<HBCIMsgStatus> doJobs() {
        HBCIMessage msg;
        log.info(HBCIUtils.getLocMsg("LOG_PROCESSING_JOBS"));
        ArrayList<HBCIMsgStatus> messageStatusList = new ArrayList<HBCIMsgStatus>();
        while ((msg = this.queue.poll()) != null) {
            this.patchMessageForSca(msg);
            HBCIMsgStatus msgstatus = new HBCIMsgStatus();
            boolean addMsgStatus = true;
            try {
                int taskNum = 0;
                Message message = MessageFactory.createMessage("CustomMsg", this.passport.getSyntaxDocument());
                for (AbstractHBCIJob abstractHBCIJob : msg.getTasks()) {
                    if (abstractHBCIJob.skipped()) continue;
                    abstractHBCIJob.applyOffset();
                    abstractHBCIJob.setIdx(taskNum);
                    String header = HBCIUtils.withCounter("GV", taskNum);
                    abstractHBCIJob.getLowlevelParams().forEach((key, value) -> message.rawSet(header + "." + key, (String)value));
                    ++taskNum;
                }
                if (taskNum == 0) {
                    addMsgStatus = false;
                    break;
                }
                message.rawSet("MsgHead.dialogid", this.dialogId);
                message.rawSet("MsgHead.msgnum", Long.toString(this.msgnum));
                message.rawSet("MsgTail.msgnum", Long.toString(this.msgnum));
                msgstatus = this.kernel.rawDoIt(message, true, true);
                this.nextMsgNum();
                int segnum = msgstatus.findTaskSegment();
                if (segnum != 0) {
                    for (AbstractHBCIJob task2 : msg.getTasks()) {
                        if (task2.skipped()) continue;
                        try {
                            task2.fillJobResult(msgstatus, segnum);
                        }
                        catch (Exception e) {
                            msgstatus.addException(e);
                        }
                    }
                }
                if (msgstatus.hasExceptions()) {
                    log.error("aborting current loop because of errors");
                    break;
                }
                Object var8_13 = null;
                for (AbstractHBCIJob task : msg.getTasks()) {
                    void var8_14;
                    AbstractHBCIJob redo;
                    if (task.skipped() || (redo = task.redo()) == null) continue;
                    if (var8_14 == null) {
                        HBCIMessage hBCIMessage = new HBCIMessage();
                        this.queue.append(hBCIMessage);
                    }
                    log.debug("repeat task " + redo.getName());
                    var8_14.append(redo);
                }
            }
            catch (Exception e) {
                msgstatus.addException(e);
            }
            finally {
                if (!addMsgStatus) continue;
                messageStatusList.add(msgstatus);
            }
        }
        return messageStatusList;
    }

    private void patchMessageForSca(HBCIMessage msg) {
        AbstractHBCIJob tan2StepRequiredJob = msg.getTasks().stream().filter(AbstractHBCIJob::isNeedsTan).findAny().orElse(null);
        if (tan2StepRequiredJob != null && msg.findTask("HKTAN") == null) {
            GVTAN2Step hktan = new GVTAN2Step(this.getPassport(), tan2StepRequiredJob);
            hktan.setProcess(KnownTANProcess.PROCESS2_STEP1);
            hktan.setSegVersion(this.getPassport().getCurrentSecMechInfo().getSegversion());
            if (this.getPassport().tanMediaNeeded()) {
                hktan.setParam("tanmedia", this.getPassport().getCurrentSecMechInfo().getMedium());
            }
            msg.append(hktan);
        }
    }

    @Override
    public HBCIExecStatus execute(boolean close) {
        HBCIExecStatus ret = new HBCIExecStatus();
        log.debug("executing dialog");
        try {
            ret.setMsgStatusList(this.doJobs());
        }
        catch (Exception e) {
            ret.addException(e);
        }
        if (close) {
            this.close();
        }
        return ret;
    }

    @Override
    public long getMsgnum() {
        return this.msgnum;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    private void nextMsgNum() {
        ++this.msgnum;
    }
}

