/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.dialog;

import java.util.Collections;
import java.util.HashMap;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIInstMessage;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHbciDialog {
    private static final Logger log = LoggerFactory.getLogger(AbstractHbciDialog.class);
    protected final PinTanPassport passport;
    protected final HBCIKernel kernel;
    String dialogId;
    long msgnum;
    private boolean closed;

    AbstractHbciDialog(PinTanPassport passport) {
        this.passport = passport;
        this.kernel = new HBCIKernel(passport);
    }

    public abstract HBCIExecStatus execute(boolean var1);

    public abstract boolean isAnonymous();

    public HBCIMsgStatus dialogInit(boolean scaRequired) {
        return this.dialogInit(scaRequired, "HKIDN");
    }

    public HBCIMsgStatus dialogInit(boolean scaRequired, String orderSegCode) {
        log.debug("start dialog");
        HBCIMsgStatus msgStatus = new HBCIMsgStatus();
        log.debug(HBCIUtils.getLocMsg("STATUS_DIALOG_INIT"));
        this.passport.getCallback().status(17, null);
        Message message = MessageFactory.createDialogInit("DialogInit", null, this.passport, scaRequired, orderSegCode);
        msgStatus = this.kernel.rawDoIt(message, true, true);
        this.passport.postInitResponseHook(msgStatus);
        HashMap<String, String> result = msgStatus.getData();
        if (msgStatus.isOK()) {
            this.msgnum = 2L;
            this.dialogId = result.get("MsgHead.dialogid");
            this.handleBankMessages(result);
            this.passport.updateUPD(result);
        }
        this.passport.getCallback().status(18, new Object[]{msgStatus, this.dialogId});
        return msgStatus;
    }

    public HBCIMsgStatus close() {
        if (this.closed || this.dialogId == null) {
            return null;
        }
        HBCIMsgStatus msgStatus = new HBCIMsgStatus();
        try {
            log.debug(HBCIUtils.getLocMsg("LOG_DIALOG_END"));
            this.passport.getCallback().status(19, null);
            Message message = MessageFactory.createDialogEnd(this.isAnonymous(), this.passport, this.dialogId, this.getMsgnum());
            msgStatus = this.kernel.rawDoIt(message, !this.isAnonymous(), !this.isAnonymous());
            this.passport.getCallback().status(20, msgStatus);
        }
        catch (Exception e) {
            msgStatus.addException(e);
        }
        finally {
            this.closed = true;
        }
        return msgStatus;
    }

    private void handleBankMessages(HashMap<String, String> result) {
        int i = 0;
        while (true) {
            HBCIInstMessage bankMessage;
            try {
                String header = HBCIUtils.withCounter("KIMsg", i);
                bankMessage = new HBCIInstMessage(result, header);
            }
            catch (Exception e) {
                break;
            }
            this.passport.getCallback().callback(14, Collections.singletonList(bankMessage.toString()), 0, new StringBuilder());
            ++i;
        }
    }

    public PinTanPassport getPassport() {
        return this.passport;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public long getMsgnum() {
        return this.msgnum;
    }
}

