/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

public class GVSaldoReq
extends AbstractHBCIJob {
    public GVSaldoReq(HBCIPassportInternal passport, String name) {
        super(passport, name, new GVRSaldoReq(passport));
    }

    public GVSaldoReq(HBCIPassportInternal passport) {
        this(passport, GVSaldoReq.getLowlevelName());
        this.addConstraint("my.country", "KTV.KIK.country", "DE");
        this.addConstraint("my.blz", "KTV.KIK.blz", null);
        this.addConstraint("my.number", "KTV.number", null);
        this.addConstraint("my.subnumber", "KTV.subnumber", "");
        this.addConstraint("my.curr", "curr", "EUR");
        this.addConstraint("dummyall", "allaccounts", "N");
        this.addConstraint("maxentries", "maxentries", "");
    }

    public static String getLowlevelName() {
        return "Saldo";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRSaldoReq.Info info = new GVRSaldoReq.Info();
        info.konto = new Konto();
        info.konto.country = result.get(header + ".KTV.KIK.country");
        info.konto.blz = result.get(header + ".KTV.KIK.blz");
        info.konto.number = result.get(header + ".KTV.number");
        info.konto.subnumber = result.get(header + ".KTV.subnumber");
        info.konto.bic = result.get(header + ".KTV.bic");
        info.konto.iban = result.get(header + ".KTV.iban");
        info.konto.type = result.get(header + ".kontobez");
        info.konto.curr = result.get(header + ".curr");
        this.passport.fillAccountInfo(info.konto);
        info.ready = new Saldo();
        String cd = result.get(header + ".booked.CreditDebit");
        String bookedValue = result.get(header + ".booked.BTG.value") != null ? result.get(header + ".booked.BTG.value") : "0";
        String st = (cd.equals("D") ? "-" : "") + bookedValue;
        info.ready.value = new Value(st, result.get(header + ".booked.BTG.curr"));
        info.ready.timestamp = HBCIUtils.strings2DateTimeISO(result.get(header + ".booked.date"), result.get(header + ".booked.time"));
        cd = result.get(header + ".pending.CreditDebit");
        if (cd != null) {
            String pendingValue = result.get(header + ".booked.BTG.value") != null ? result.get(header + ".pending.BTG.value") : "0";
            st = (cd.equals("D") ? "-" : "") + pendingValue;
            info.unready = new Saldo();
            info.unready.value = new Value(st, result.get(header + ".pending.BTG.curr"));
            info.unready.timestamp = HBCIUtils.strings2DateTimeISO(result.get(header + ".pending.date"), result.get(header + ".pending.time"));
        }
        if ((st = result.get(header + ".kredit.value")) != null) {
            info.kredit = new Value(st, result.get(header + ".kredit.curr"));
        }
        if ((st = result.get(header + ".available.value")) != null) {
            info.available = new Value(st, result.get(header + ".available.curr"));
        }
        if ((st = result.get(header + ".used.value")) != null) {
            info.used = new Value(st, result.get(header + ".used.curr"));
        }
        ((GVRSaldoReq)this.jobResult).store(info);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

