/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.sepa;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kapott.hbci.GV.generators.PainGeneratorIf;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.comm.CommPinTan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SepaVersion
implements Comparable<SepaVersion> {
    private static final Logger log = LoggerFactory.getLogger(SepaVersion.class);
    private static final Pattern PATTERN = Pattern.compile("([a-z]{2,8})\\.(\\d\\d\\d)\\.(\\d\\d\\d)\\.(\\d\\d)");
    private static final Map<Type, List<SepaVersion>> knownVersions = new EnumMap<Type, List<SepaVersion>>(Type.class);
    private static final String DF_MAJOR = "000";
    private static final String DF_MINOR = "00";
    public static final SepaVersion PAIN_001_001_02 = new SepaVersion(SupportType.GENERATE, 1, "urn:sepade:xsd:pain.001.001.02", "pain.001.001.02.xsd", true);
    public static final SepaVersion PAIN_001_002_02 = new SepaVersion(SupportType.GENERATE, 2, "urn:swift:xsd:$pain.001.002.02", "pain.001.002.02.xsd", true);
    public static final SepaVersion PAIN_001_002_03 = new SepaVersion(SupportType.GENERATE, 3, "urn:iso:std:iso:20022:tech:xsd:pain.001.002.03", "pain.001.002.03.xsd", true);
    public static final SepaVersion PAIN_001_003_03 = new SepaVersion(SupportType.GENERATE, 4, "urn:iso:std:iso:20022:tech:xsd:pain.001.003.03", "pain.001.003.03.xsd", true);
    public static final SepaVersion PAIN_001_001_03 = new SepaVersion(SupportType.GENERATE, 5, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "pain.001.001.03.xsd", true);
    public static final SepaVersion PAIN_001_001_09 = new SepaVersion(SupportType.GENERATE, 6, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "pain.001.001.09.xsd", true);
    public static final SepaVersion PAIN_001_001_09_AXZ_GBIC_4 = new SepaVersion(SupportType.GENERATE, 7, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "pain.001.001.09_AXZ_GBIC_4.xsd", true);
    public static final SepaVersion PAIN_001_001_09_CCU_GBIC_4 = new SepaVersion(SupportType.GENERATE, 8, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "pain.001.001.09_CCU_GBIC_4.xsd", true);
    public static final SepaVersion PAIN_001_001_09_GBIC_4 = new SepaVersion(SupportType.GENERATE, 9, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.09", "pain.001.001.09_GBIC_4.xsd", true);
    public static final SepaVersion PAIN_002_002_02 = new SepaVersion(SupportType.GENERATE, 1, "urn:swift:xsd:$pain.002.002.02", "pain.002.002.02.xsd", true);
    public static final SepaVersion PAIN_002_003_03 = new SepaVersion(SupportType.GENERATE, 2, "urn:iso:std:iso:20022:tech:xsd:pain.002.003.03", "pain.002.003.03.xsd", true);
    public static final SepaVersion PAIN_002_001_03 = new SepaVersion(SupportType.GENERATE, 3, "urn:iso:std:iso:20022:tech:xsd:pain.002.001.03", "pain.002.001.03.xsd", true);
    public static final SepaVersion PAIN_008_001_01 = new SepaVersion(SupportType.GENERATE, 1, "urn:sepade:xsd:pain.008.001.01", "pain.008.001.01.xsd", true);
    public static final SepaVersion PAIN_008_002_01 = new SepaVersion(SupportType.GENERATE, 2, "urn:swift:xsd:$pain.008.002.01", "pain.008.002.01.xsd", true);
    public static final SepaVersion PAIN_008_002_02 = new SepaVersion(SupportType.GENERATE, 3, "urn:iso:std:iso:20022:tech:xsd:pain.008.002.02", "pain.008.002.02.xsd", true);
    public static final SepaVersion PAIN_008_003_02 = new SepaVersion(SupportType.GENERATE, 4, "urn:iso:std:iso:20022:tech:xsd:pain.008.003.02", "pain.008.003.02.xsd", true);
    public static final SepaVersion PAIN_008_001_02 = new SepaVersion(SupportType.GENERATE, 5, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02", "pain.008.001.02.xsd", true);
    public static final SepaVersion CAMT_052_001_01 = new SepaVersion(SupportType.PARSE, 1, "urn:iso:std:iso:20022:tech:xsd:camt.052.001.01", "camt.052.001.01.xsd", true);
    public static final SepaVersion CAMT_052_001_02 = new SepaVersion(SupportType.PARSE, 2, "urn:iso:std:iso:20022:tech:xsd:camt.052.001.02", "camt.052.001.02.xsd", true);
    public static final SepaVersion CAMT_052_001_03 = new SepaVersion(SupportType.PARSE, 3, "urn:iso:std:iso:20022:tech:xsd:camt.052.001.03", "camt.052.001.03.xsd", true);
    public static final SepaVersion CAMT_052_001_05 = new SepaVersion(SupportType.PARSE, 5, "urn:iso:std:iso:20022:tech:xsd:camt.052.001.05", "camt.052.001.05.xsd", true);
    public static final SepaVersion CAMT_052_001_06 = new SepaVersion(SupportType.PARSE, 6, "urn:iso:std:iso:20022:tech:xsd:camt.052.001.06", "camt.052.001.06.xsd", true);
    public static final SepaVersion CAMT_052_001_07 = new SepaVersion(SupportType.PARSE, 7, "urn:iso:std:iso:20022:tech:xsd:camt.052.001.07", "camt.052.001.07.xsd", true);
    public static final SepaVersion CAMT_052_001_08 = new SepaVersion(SupportType.PARSE, 8, "urn:iso:std:iso:20022:tech:xsd:camt.052.001.08", "camt.052.001.08.xsd", true);
    public static final SepaVersion CAMT_053_001_02 = new SepaVersion(SupportType.PARSE, 8, "urn:iso:std:iso:20022:tech:xsd:camt.053.001.02", "camt.053.001.02.xsd", true);
    public static final SepaVersion CAMT_052_001_04 = new SepaVersion(SupportType.PARSE, 4, "urn:iso:std:iso:20022:tech:xsd:camt.052.001.04", "camt.052.001.04.xsd", true);
    private SupportType support;
    private String urn;
    private String file;
    private Type type;
    private int major;
    private int minor;
    private int order;

    private SepaVersion(SupportType support, int order, String urn, String file, boolean add) {
        Matcher m = PATTERN.matcher(urn);
        if (!m.find() || m.groupCount() != 4) {
            throw new IllegalArgumentException("invalid sepa-version: " + urn);
        }
        this.support = support;
        this.order = order;
        this.urn = urn;
        this.file = file;
        this.type = SepaVersion.findType(m.group(1), m.group(2));
        this.major = Integer.parseInt(m.group(3));
        this.minor = Integer.parseInt(m.group(4));
        if (add) {
            knownVersions.computeIfAbsent(this.type, type1 -> new ArrayList()).add(this);
        }
    }

    public static SepaVersion byURN(String urn) {
        SepaVersion test = new SepaVersion(null, 0, urn, null, false);
        if (urn == null || urn.length() == 0) {
            return test;
        }
        for (List<SepaVersion> types : knownVersions.values()) {
            for (SepaVersion v : types) {
                if (!v.equals(test)) continue;
                return v;
            }
        }
        return test;
    }

    public static SepaVersion byFileName(String fileName) {
        return knownVersions.values().stream().flatMap(Collection::stream).filter(sepaVersion -> sepaVersion.getFile().equals(fileName)).findFirst().orElseThrow(() -> new IllegalArgumentException("unknown sepa schema file name: " + fileName));
    }

    private static Type findType(String type, String value) {
        if (type == null || type.length() == 0) {
            throw new IllegalArgumentException("no SEPA type type given");
        }
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("no SEPA version value given");
        }
        for (Type t : Type.values()) {
            if (!t.getType().equalsIgnoreCase(type) || !t.getValue().equals(value)) continue;
            return t;
        }
        throw new IllegalArgumentException("unknown SEPA version type: " + type + "." + value);
    }

    public static SepaVersion findGreatest(List<SepaVersion> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        try {
            Collections.sort(list);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return list.get(list.size() - 1);
    }

    public static List<SepaVersion> getKnownVersions(Type t) {
        return knownVersions.get((Object)t);
    }

    public static SepaVersion autodetect(InputStream xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xml);
            Node root = doc.getFirstChild();
            if (root == null) {
                throw new IllegalArgumentException("XML data did not contain a root element");
            }
            String uri = root.getNamespaceURI();
            if (uri == null) {
                return null;
            }
            return SepaVersion.byURN(uri);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static SepaVersion autodetect(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            Node root = doc.getFirstChild();
            if (root == null) {
                throw new IllegalArgumentException("XML data did not contain a root element");
            }
            return Optional.ofNullable(root.getNamespaceURI()).map(SepaVersion::byURN).orElseThrow(() -> new IllegalArgumentException("Invalid pain xml"));
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static SepaVersion choose(String sepadesc, String sepadata) {
        boolean haveData;
        boolean haveDesc = sepadesc != null && sepadesc.length() > 0;
        boolean bl = haveData = sepadata != null && sepadata.length() > 0;
        if (!haveDesc && !haveData) {
            log.warn("neither sepadesr nor sepa data given");
            return null;
        }
        SepaVersion versionDesc = haveDesc ? SepaVersion.byURN(sepadesc) : null;
        SepaVersion versionData = haveData ? SepaVersion.autodetect(new ByteArrayInputStream(sepadata.getBytes(CommPinTan.ENCODING))) : null;
        log.debug("sepa version given in sepadescr: " + versionDesc);
        log.debug("sepa version according to data: " + versionData);
        if (versionDesc == null) {
            return versionData;
        }
        if (versionData == null) {
            return versionDesc;
        }
        if (!versionDesc.equals(versionData)) {
            log.warn("sepa version mismatch. sepadesc: " + versionDesc + " vs. data: " + versionData);
        }
        return versionData;
    }

    public String getSchemaLocation() {
        if (this.file == null) {
            return null;
        }
        return this.urn + " " + this.file;
    }

    public String getGeneratorClass(String jobName) {
        return PainGeneratorIf.class.getPackage().getName() + ".Gen" + jobName + this.type.getValue() + new DecimalFormat(DF_MAJOR).format(this.major) + new DecimalFormat(DF_MINOR).format(this.minor);
    }

    public String getParserClass() {
        return ISEPAParser.class.getPackage().getName() + ".Parse" + this.type.getType() + this.type.getValue() + new DecimalFormat(DF_MAJOR).format(this.major) + new DecimalFormat(DF_MINOR).format(this.minor);
    }

    public boolean canGenerate(String jobName) {
        try {
            Class.forName(this.getGeneratorClass(jobName));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean canParse() {
        try {
            Class.forName(this.getParserClass());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean isSupported(String jobName) {
        return this.support == SupportType.GENERATE ? this.canGenerate(jobName) : this.canParse();
    }

    public Type getType() {
        return this.type;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getURN() {
        return this.urn;
    }

    public String getFile() {
        return this.file;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SepaVersion)) {
            return false;
        }
        SepaVersion other = (SepaVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public int compareTo(SepaVersion v) {
        if (v.type != this.type) {
            throw new IllegalArgumentException("sepa-type incompatible: " + v.type + " != " + this.type);
        }
        int r = this.order - v.order;
        if (r != 0) {
            return r;
        }
        r = this.major - v.major;
        if (r != 0) {
            return r;
        }
        return this.minor - v.minor;
    }

    public String toString() {
        return this.urn;
    }

    public static enum Type {
        PAIN_001("Pain", "001", "credit transfer"),
        PAIN_002("Pain", "002", "payment status"),
        PAIN_008("Pain", "008", "direct debit"),
        CAMT_052("Camt", "052", "bank to customer cash management"),
        CAMT_053("Camt", "053", "bank to customer cash management");

        private String type;
        private String value;
        private String name;

        private Type(String type, String value, String name) {
            this.type = type;
            this.value = value;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum SupportType {
        GENERATE,
        PARSE;

    }
}

