/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.rewrite;

import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.kapott.hbci.rewrite.Rewrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class RSecTypeTAN
extends Rewrite {
    private static final Logger log = LoggerFactory.getLogger(RSecTypeTAN.class);

    @Override
    public String incomingClearText(String st, Document document, String msgName) {
        String elemBaseName;
        SyntaxElement elem;
        String myMsgName = msgName + "Res";
        Message msg = new Message(myMsgName, st, document, true, false);
        int i = 0;
        while ((elem = msg.getElement((elemBaseName = HBCIUtils.withCounter(myMsgName + ".BPD.SecMethod.SuppSecMethods", i)) + ".method")) != null) {
            String method = elem.toString();
            if (method.equals("TAN")) {
                int endpos;
                int startpos;
                log.warn("there is an invalid sec type (TAN) in this BPD - removing it");
                SyntaxElement parent = elem.getParent().getParent().getParent().getParent();
                String parentPath = parent.getPath();
                int number = 0;
                for (MultipleSyntaxElements childContainer : parent.getChildContainers()) {
                    if (!childContainer.getPath().equals(parentPath + ".SuppSecMethods")) continue;
                    number = childContainer.getElements().size();
                    break;
                }
                if (number > 1) {
                    startpos = elem.getPosInMsg();
                    endpos = startpos + 1 + elem.toString(0).length() + 1 + msg.getElement(elemBaseName + ".version").toString(0).length();
                } else {
                    startpos = parent.getPosInMsg() + 1;
                    endpos = startpos + parent.toString(0).length();
                }
                st = new StringBuffer(st).delete(startpos, endpos).toString();
                log.debug("new message after removing: " + st);
                break;
            }
            ++i;
        }
        return st;
    }
}

