/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.NoSuchPathException;
import org.kapott.hbci.protocol.DE;
import org.kapott.hbci.protocol.MultipleSEGs;
import org.kapott.hbci.protocol.MultipleSFs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SEG;
import org.kapott.hbci.protocol.SyntaxElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class Message
extends SyntaxElement {
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    public static final boolean CHECK_SEQ = true;
    public static final boolean DONT_CHECK_SEQ = false;
    public static final boolean DONT_CHECK_VALIDS = false;
    private Document document;
    private Map<String, String> clientValues = new HashMap<String, String>();

    public Message(String type, Document document) {
        super(type, type, null, 0, document);
    }

    public Message(String type, String res, Document document, boolean checkSeq, boolean checkValids) {
        super(type, type, null, '\u0000', 0, new StringBuilder(res), res.length(), document, new HashMap<String, String>(), checkValids ? new HashMap() : null);
        if (checkSeq) {
            this.checkSegSeq(1);
        }
    }

    public void init(String type, Document document) {
        super.init(type, type, null, 0, document);
    }

    @Override
    protected MultipleSyntaxElements createNewChildContainer(Node ref, Document document) {
        this.document = document;
        MultipleSyntaxElements ret = null;
        if (ref.getNodeName().equals("SEG")) {
            ret = new MultipleSEGs(ref, this.getPath(), document);
        } else if (ref.getNodeName().equals("SF")) {
            ret = new MultipleSFs(ref, this.getPath(), document);
        }
        return ret;
    }

    @Override
    protected String getElementTypeName() {
        return "MSG";
    }

    private void propagateUserData(Map<String, String> clientValues) {
        String dottedName = this.getName() + ".";
        clientValues.forEach((key, value) -> {
            if (key.startsWith(dottedName) && value != null && value.length() != 0 && !this.propagateValue((String)key, (String)value, true, false)) {
                log.warn("could not insert the following user-defined data into message: " + key + "=" + value);
            }
        });
    }

    private void setMsgSizeValue(int value, boolean allowOverwrite) {
        String absPath = this.getPath() + ".MsgHead.msgsize";
        SyntaxElement msgsizeElem = this.getElement(absPath);
        if (msgsizeElem == null) {
            throw new NoSuchPathException(absPath);
        }
        int size = ((DE)msgsizeElem).getMinSize();
        char[] zeros = new char[size];
        Arrays.fill(zeros, '0');
        DecimalFormat df = new DecimalFormat(String.valueOf(zeros));
        if (!this.propagateValue(absPath, df.format(value), false, allowOverwrite)) {
            throw new NoSuchPathException(absPath);
        }
    }

    private void initMsgSize() {
        this.setMsgSizeValue(0, false);
    }

    public void autoSetMsgSize() {
        this.setMsgSizeValue(this.toString(0).length(), true);
    }

    public void complete() {
        this.propagateUserData(this.clientValues);
        this.enumerateSegs(0, false);
        this.initMsgSize();
        this.validate();
        this.enumerateSegs(1, true);
        this.autoSetMsgSize();
    }

    @Override
    public String toString(int dummy) {
        StringBuilder ret = new StringBuilder(1024);
        if (this.isValid()) {
            for (MultipleSyntaxElements list : this.getChildContainers()) {
                if (list == null) continue;
                ret.append(list.toString(0));
            }
        }
        return ret.toString();
    }

    public void init(String type, String res, Document document, boolean checkSeq, boolean checkValids) {
        super.init(type, type, null, '\u0000', 0, new StringBuilder(res), res.length(), document, new HashMap<String, String>(), checkValids ? new HashMap() : null);
        if (checkSeq) {
            this.checkSegSeq(1);
        }
    }

    @Override
    protected char getInDelim() {
        return '\'';
    }

    @Override
    protected MultipleSyntaxElements parseNewChildContainer(Node segref, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        MultipleSyntaxElements ret = null;
        if (segref.getNodeName().equals("SEG")) {
            ret = new MultipleSEGs(segref, this.getPath(), predelim0, predelim1, res, fullResLen, document, predefs, valids);
        } else if (segref.getNodeName().equals("SF")) {
            ret = new MultipleSFs(segref, this.getPath(), predelim0, predelim1, res, fullResLen, document, predefs, valids);
        }
        return ret;
    }

    @Override
    public String getValueOfDE(String path) {
        String ret = null;
        for (MultipleSyntaxElements l : this.getChildContainers()) {
            String temp = l.getValueOfDE(path);
            if (temp == null) continue;
            ret = temp;
            break;
        }
        if (ret == null) {
            throw new NoSuchPathException(path);
        }
        return ret;
    }

    public Map<String, String> getData() {
        HashMap<String, String> hash = new HashMap<String, String>();
        HashMap<String, String> p = new HashMap<String, String>();
        int nameskip = this.getName().length() + 1;
        this.extractValues(hash);
        hash.forEach((key, value) -> p.put(key.substring(nameskip), (String)value));
        return p;
    }

    @Override
    public void getElementPaths(Map<String, String> p, int[] segref, int[] degref, int[] deref) {
        segref = new int[]{1};
        for (MultipleSyntaxElements l : this.getChildContainers()) {
            if (l == null) continue;
            l.getElementPaths(p, segref, null, null);
        }
    }

    public boolean isCrypted() {
        MultipleSyntaxElements seglist = this.getChildContainers().get(1);
        if (seglist instanceof MultipleSEGs) {
            try {
                SEG crypthead = (SEG)seglist.getElements().get(0);
                if (crypthead.getCode().equals("HNVSK")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public byte[] getPlainString() {
        try {
            StringBuilder ret = new StringBuilder(1024);
            List<MultipleSyntaxElements> childs = this.getChildContainers();
            int len = childs.size();
            for (int i = 1; i < len - 1; ++i) {
                ret.append(childs.get(i).toString(0));
            }
            int padLength = 8 - ret.length() % 8;
            for (int i = 0; i < padLength - 1; ++i) {
                ret.append('\u0000');
            }
            ret.append((char)padLength);
            return ret.toString().getBytes(CommPinTan.ENCODING);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** error while extracting plain message string", ex);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void set(String path, String value) {
        this.clientValues.put(path, value);
    }

    public void rawSet(String path, String value) {
        this.set(this.getName() + "." + path, value);
    }

    public String get(String key) {
        return this.clientValues.get(key);
    }
}

