/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.AccountCRCAlgs;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.structures.Konto;
import org.slf4j.LoggerFactory;

public final class HBCIUtils {
    private static final String VERSION = "HBCI4Java-2.5.12";
    public static Map<String, BankInfo> banks = new HashMap<String, BankInfo>();
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("hbci4java-messages", Locale.getDefault());

    public static String getNameForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getName() != null ? info.getName() : "";
    }

    public static BankInfo getBankInfo(String blz) {
        return banks.get(blz);
    }

    public static List<BankInfo> searchBankInfo(String query) {
        if (query != null) {
            query = query.trim();
        }
        LinkedList<BankInfo> list = new LinkedList<BankInfo>();
        if (query == null || query.length() < 3) {
            return list;
        }
        query = query.toLowerCase();
        for (BankInfo info : banks.values()) {
            String blz = info.getBlz();
            String bic = info.getBic();
            String name = info.getName();
            String loc = info.getLocation();
            if (blz != null && blz.startsWith(query)) {
                list.add(info);
                continue;
            }
            if (bic != null && bic.toLowerCase().startsWith(query)) {
                list.add(info);
                continue;
            }
            if (name != null && name.toLowerCase().contains(query)) {
                list.add(info);
                continue;
            }
            if (loc == null || !loc.toLowerCase().contains(query)) continue;
            list.add(info);
        }
        Collections.sort(list, new Comparator<BankInfo>(){

            @Override
            public int compare(BankInfo o1, BankInfo o2) {
                if (o1 == null || o1.getBlz() == null) {
                    return -1;
                }
                if (o2 == null || o2.getBlz() == null) {
                    return 1;
                }
                return o1.getBlz().compareTo(o2.getBlz());
            }
        });
        return list;
    }

    public static String getBICForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getBic() != null ? info.getBic() : "";
    }

    public static String getIBANForKonto(Konto k) {
        Object konto = k.number;
        if (k.subnumber != null && k.subnumber.length() > 0 && k.subnumber.matches("[0-9]{1,8}") && k.number.length() + k.subnumber.length() <= 10) {
            konto = (String)konto + k.subnumber;
        }
        String zeros = "0000000000";
        String filledKonto = zeros.substring(0, 10 - ((String)konto).length()) + (String)konto;
        StringBuffer sb = new StringBuffer();
        sb.append(k.blz);
        sb.append(filledKonto);
        sb.append("1314");
        sb.append("00");
        BigInteger mod = new BigInteger(sb.toString()).mod(new BigInteger("97"));
        Object checksum = String.valueOf(98 - mod.intValue());
        if (((String)checksum).length() < 2) {
            checksum = "0" + (String)checksum;
        }
        StringBuffer result = new StringBuffer();
        result.append("DE");
        result.append((String)checksum);
        result.append(k.blz);
        result.append(filledKonto);
        return result.toString();
    }

    public static String getHBCIHostForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getRdhAddress() != null ? info.getRdhAddress() : "";
    }

    public static String getPinTanURLForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getPinTanAddress() != null ? info.getPinTanAddress() : "";
    }

    public static String getHBCIVersionForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getRdhVersion() != null ? info.getRdhVersion().getId() : "";
    }

    public static String getPinTanVersionForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getPinTanVersion() != null ? info.getPinTanVersion().getId() : "";
    }

    public static String exception2String(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString().trim();
    }

    public static String exception2StringShort(Exception e) {
        StringBuffer st = new StringBuffer();
        for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
            String exClass = e2.getClass().getName();
            String msg = e2.getMessage();
            if (msg == null) continue;
            st.setLength(0);
            st.append(exClass);
            st.append(": ");
            st.append(msg);
        }
        return st.toString().trim();
    }

    public static String data2hex(byte[] data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            Object st = Integer.toHexString(data[i]);
            if (((String)st).length() == 1) {
                st = "0" + (String)st;
            }
            st = ((String)st).substring(((String)st).length() - 2);
            ret.append((String)st).append(" ");
        }
        return ret.toString();
    }

    public static String date2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getDateInstance(3, Locale.getDefault()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date string2DateLocal(String date) {
        Date ret;
        try {
            ret = DateFormat.getDateInstance(3, Locale.getDefault()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date);
        }
        return ret;
    }

    public static String time2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getTimeInstance(3, Locale.getDefault()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date string2TimeLocal(String date) {
        Date ret;
        try {
            ret = DateFormat.getTimeInstance(3, Locale.getDefault()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date);
        }
        return ret;
    }

    public static String datetime2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date strings2DateTimeLocal(String date, String time) {
        Date ret;
        try {
            ret = time != null ? DateFormat.getDateTimeInstance(3, 3, Locale.getDefault()).parse(date + " " + time) : DateFormat.getDateInstance(3, Locale.getDefault()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date + " / " + time);
        }
        return ret;
    }

    public static String date2StringISO(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static Date string2DateISO(String st) {
        return HBCIUtils.string2DateISO(st, "yyyy-MM-dd");
    }

    public static Date string2DateISO(String st, String format) {
        try {
            return new SimpleDateFormat(format).parse(st);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(st);
        }
    }

    public static String time2StringISO(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public static Date string2TimeISO(String st) {
        try {
            return new SimpleDateFormat("HH:mm:ss").parse(st);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(st);
        }
    }

    public static String datetime2StringISO(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static Date strings2DateTimeISO(String date, String time) {
        Date result;
        if (date == null) {
            throw new InvalidArgumentException("*** date must not be null");
        }
        try {
            result = time != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date + " " + time) : new SimpleDateFormat("yyyy-MM-dd").parse(date);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(date + " / " + time);
        }
        return result;
    }

    private static Method getAccountCRCMethodByAlg(String alg) {
        Class<AccountCRCAlgs> cl = null;
        Method method = null;
        try {
            cl = AccountCRCAlgs.class;
            method = cl.getMethod("alg_" + alg, int[].class, int[].class);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(HBCIUtils.class).warn("CRC algorithm " + alg + " not yet implemented");
        }
        return method;
    }

    public static boolean checkAccountCRC(String blz, String number) {
        String alg;
        BankInfo info = HBCIUtils.getBankInfo(blz);
        String string = alg = info != null ? info.getChecksumMethod() : null;
        if (alg == null || alg.length() != 2) {
            LoggerFactory.getLogger(HBCIUtils.class).warn("no crc information about " + blz + " in database");
            return true;
        }
        LoggerFactory.getLogger(HBCIUtils.class).debug("crc-checking " + blz + "/" + number);
        return HBCIUtils.checkAccountCRCByAlg(alg, blz, number);
    }

    private static int[] string2Ints(String st, int target_length) {
        int[] numbers = new int[target_length];
        int st_len = st.length();
        for (int i = 0; i < st_len; ++i) {
            char ch = st.charAt(i);
            numbers[target_length - st_len + i] = ch - 48;
        }
        return numbers;
    }

    public static boolean checkAccountCRCByAlg(String alg, String blz, String number) {
        boolean ret = true;
        if (blz == null || number == null) {
            throw new NullPointerException("blz and number must not be null");
        }
        if (number.length() <= 10) {
            Method method = HBCIUtils.getAccountCRCMethodByAlg(alg);
            if (method != null) {
                try {
                    int[] blz_digits = HBCIUtils.string2Ints(blz, 8);
                    int[] number_digits = HBCIUtils.string2Ints(number, 10);
                    Object[] args = new Object[]{blz_digits, number_digits};
                    ret = (Boolean)method.invoke(null, args);
                    LoggerFactory.getLogger(HBCIUtils.class).debug("\"CRC check for \"+blz+\"/\"+number+\" with alg \"+alg+\": \"+ret");
                }
                catch (Exception e) {
                    throw new HBCI_Exception(e);
                }
            }
        } else {
            LoggerFactory.getLogger(HBCIUtils.class).warn("can not check account numbers with more than 10 digits (" + number + ")- skipping CRC check");
        }
        return ret;
    }

    public static boolean checkAccountCRCByAlg(String alg, String number) {
        return HBCIUtils.checkAccountCRCByAlg(alg, "", number);
    }

    public static boolean checkIBANCRC(String iban) {
        return AccountCRCAlgs.checkIBAN(iban);
    }

    public static boolean checkCredtitorIdCRC(String creditorId) {
        return AccountCRCAlgs.checkCreditorId(creditorId);
    }

    private static void refreshBLZList(String blzpath) throws IOException {
        FileInputStream f;
        if (blzpath == null) {
            blzpath = "";
        }
        if ((f = new FileInputStream((String)(blzpath = (String)blzpath + "blz.properties"))) == null) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_BLZLOAD", blzpath));
        }
        HBCIUtils.refreshBLZList(f);
        ((InputStream)f).close();
    }

    public static void refreshBLZList(InputStream in) throws IOException {
        LoggerFactory.getLogger(HBCIUtils.class).debug("trying to load BLZ data");
        Properties blzs = new Properties();
        blzs.load(in);
        banks.clear();
        for (Map.Entry<Object, Object> e : blzs.entrySet()) {
            String blz = (String)e.getKey();
            String value = (String)e.getValue();
            BankInfo info = BankInfo.parse(value);
            info.setBlz(blz);
            banks.put(blz, info);
        }
    }

    public static void addBankInfo(BankInfo bankInfo) {
        banks.put(bankInfo.getBlz(), bankInfo);
    }

    public static BigDecimal string2BigDecimal(String st) {
        BigDecimal result = new BigDecimal(st);
        result.setScale(2, 6);
        return result;
    }

    @Deprecated
    public static double string2Value(String st) {
        return Double.parseDouble(st);
    }

    @Deprecated
    public static String value2String(double value) {
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setDecimalSeparatorAlwaysShown(true);
        return format.format(value);
    }

    public static String version() {
        return VERSION;
    }

    public static String bigDecimal2String(BigDecimal value) {
        DecimalFormat format = new DecimalFormat("0.##");
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(value);
    }

    public static String getLocMsg(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException re) {
            LoggerFactory.getLogger(HBCIUtils.class).debug(re.getMessage(), (Throwable)re);
            return key;
        }
    }

    public static String getLocMsg(String key, Object o) {
        return HBCIUtils.getLocMsg(key, new Object[]{o});
    }

    public static String getLocMsg(String key, Object[] o) {
        return MessageFormat.format(HBCIUtils.getLocMsg(key), o);
    }

    public static long string2Long(String st, long factor) {
        BigDecimal result = new BigDecimal(st);
        result = result.multiply(new BigDecimal(factor));
        return result.longValue();
    }

    public static String withCounter(String st, int idx) {
        return st + (String)(idx != 0 ? "_" + (idx + 1) : "");
    }

    public static int getPosiOfNextDelimiter(String st, int posi) {
        int len = st.length();
        boolean quoting = false;
        while (posi < len) {
            char ch = st.charAt(posi);
            if (!quoting) {
                if (ch == '?') {
                    quoting = true;
                } else if (ch == '@') {
                    int endpos = st.indexOf(64, posi + 1);
                    String binlen_st = st.substring(posi + 1, endpos);
                    int binlen = Integer.parseInt(binlen_st);
                    posi += binlen_st.length() + 1 + binlen;
                } else if (ch == '\'' || ch == '+' || ch == ':') {
                    break;
                }
            } else {
                quoting = false;
            }
            ++posi;
        }
        return posi;
    }

    public static String stripLeadingZeroes(String st) {
        String ret = null;
        if (st != null) {
            int start;
            int l = st.length();
            for (start = 0; start < l && st.charAt(start) == '0'; ++start) {
            }
            ret = st.substring(start);
        }
        return ret;
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }
}

