/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.bind.JAXB;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.CreditTransferTransaction34;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.CustomerCreditTransferInitiationV09;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.DateAndDateTimeChoice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PaymentIdentification6;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PaymentInstruction30;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.Purpose2Choice;

public class ParsePain00100109
extends AbstractSepaParser<List<HashMap<String, String>>> {
    @Override
    public void parse(InputStream xml, List<HashMap<String, String>> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        CustomerCreditTransferInitiationV09 pain = doc.getCstmrCdtTrfInitn();
        if (pain == null) {
            return;
        }
        List<PaymentInstruction30> pmtInfs = pain.getPmtInf();
        for (PaymentInstruction30 pmtInf : pmtInfs) {
            List<CreditTransferTransaction34> txList = pmtInf.getCdtTrfTxInf();
            for (CreditTransferTransaction34 tx : txList) {
                PaymentIdentification6 pmtId;
                DateAndDateTimeChoice date;
                Purpose2Choice purp;
                HashMap<String, String> prop = new HashMap<String, String>();
                this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
                this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
                this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getDbtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getDbtrAgt().getFinInstnId().getBICFI());
                this.put(prop, ISEPAParser.Names.DST_NAME, tx.getCdtr().getNm());
                this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getCdtrAcct().getId().getIBAN());
                try {
                    this.put(prop, ISEPAParser.Names.DST_BIC, tx.getCdtrAgt().getFinInstnId().getBICFI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ActiveOrHistoricCurrencyAndAmount amt = tx.getAmt().getInstdAmt();
                this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
                this.put(prop, ISEPAParser.Names.CURR, amt.getCcy().value());
                if (tx.getRmtInf() != null) {
                    this.put(prop, ISEPAParser.Names.USAGE, tx.getRmtInf().getUstrd());
                }
                if ((purp = tx.getPurp()) != null) {
                    this.put(prop, ISEPAParser.Names.PURPOSECODE, purp.getCd());
                }
                if ((date = pmtInf.getReqdExctnDt()) != null) {
                    Stream.of(date.getDt(), date.getDtTm()).filter(Objects::nonNull).findFirst().ifPresent(calendar -> this.put(prop, ISEPAParser.Names.DATE, SepaUtil.format(calendar, null)));
                }
                if ((pmtId = tx.getPmtId()) != null) {
                    this.put(prop, ISEPAParser.Names.ENDTOENDID, pmtId.getEndToEndId());
                }
                sepaResults.add(prop);
            }
        }
    }
}

