/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;

public class GVUmbSEPA
extends AbstractSEPAGV {
    private static final SepaVersion DEFAULT = SepaVersion.PAIN_001_001_02;

    public GVUmbSEPA(HBCIPassportInternal passport, SepaVersion sepaVersion) {
        this(passport, GVUmbSEPA.getLowlevelName(), sepaVersion, (String)null);
    }

    public GVUmbSEPA(HBCIPassportInternal passport, String name, SepaVersion sepaVersion, String pain) {
        super(passport, name, sepaVersion, null);
        this.addConstraint("src.bic", "My.bic", null);
        this.addConstraint("src.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("src.country", "My.KIK.country", "");
            this.addConstraint("src.blz", "My.KIK.blz", "");
            this.addConstraint("src.number", "My.number", "");
            this.addConstraint("src.subnumber", "My.subnumber", "");
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getSepaVersion().getURN());
        if (pain == null) {
            this.addConstraint("_sepapain", "sepapain", null);
        } else {
            this.setPainXml(pain);
        }
        this.addConstraint("src.bic", "sepa.src.bic", null);
        this.addConstraint("src.iban", "sepa.src.iban", null);
        this.addConstraint("src.name", "sepa.src.name", null);
        this.addConstraint("dst.bic", "sepa.dst.bic", "", true);
        this.addConstraint("dst.iban", "sepa.dst.iban", null, true);
        this.addConstraint("dst.name", "sepa.dst.name", null, true);
        this.addConstraint("btg.value", "sepa.btg.value", null, true);
        this.addConstraint("btg.curr", "sepa.btg.curr", "EUR", true);
        this.addConstraint("usage", "sepa.usage", "", true);
        this.addConstraint("sepaid", "sepa.sepaid", this.getPainMessageId());
        this.addConstraint("pmtinfid", "sepa.pmtinfid", this.getPainMessageId());
        this.addConstraint("endtoendid", "sepa.endtoendid", "NOTPROVIDED", true);
        this.addConstraint("purposecode", "sepa.purposecode", "", true);
    }

    public static String getLowlevelName() {
        return "UmbSEPA";
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_001;
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

