/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV_Result.GVRPayment;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVTermUebSEPA
extends AbstractSEPAGV {
    private static final SepaVersion DEFAULT = SepaVersion.PAIN_001_001_02;

    public GVTermUebSEPA(HBCIPassportInternal passport, SepaVersion sepaVersion) {
        this(passport, GVTermUebSEPA.getLowlevelName(), sepaVersion);
    }

    public GVTermUebSEPA(HBCIPassportInternal passport, String name, SepaVersion sepaVersion) {
        super(passport, name, sepaVersion, new GVRPayment(passport));
        this.addConstraint("src.bic", "My.bic", null);
        this.addConstraint("src.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("src.country", "My.KIK.country", "");
            this.addConstraint("src.blz", "My.KIK.blz", "");
            this.addConstraint("src.number", "My.number", "");
            this.addConstraint("src.subnumber", "My.subnumber", "");
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getSepaVersion().getURN());
        this.addConstraint("_sepapain", "sepapain", null);
        this.addConstraint("src.bic", "sepa.src.bic", null);
        this.addConstraint("src.iban", "sepa.src.iban", null);
        this.addConstraint("src.name", "sepa.src.name", null);
        this.addConstraint("dst.bic", "sepa.dst.bic", "", true);
        this.addConstraint("dst.iban", "sepa.dst.iban", null);
        this.addConstraint("dst.name", "sepa.dst.name", null);
        this.addConstraint("btg.value", "sepa.btg.value", null);
        this.addConstraint("btg.curr", "sepa.btg.curr", "EUR");
        this.addConstraint("usage", "sepa.usage", "");
        this.addConstraint("date", "sepa.date", null);
        this.addConstraint("sepaid", "sepa.sepaid", this.getPainMessageId());
        this.addConstraint("pmtinfid", "sepa.pmtinfid", this.getPainMessageId());
        this.addConstraint("endtoendid", "sepa.endtoendid", "NOTPROVIDED");
        this.addConstraint("purposecode", "sepa.purposecode", "");
    }

    public static String getLowlevelName() {
        return "TermUebSEPA";
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_001;
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        String orderid = result.get(header + ".orderid");
        ((GVRPayment)this.jobResult).setOrderId(orderid);
    }
}

