/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV_Result.GVRPayment;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVTermMultiUebSEPA
extends GVUebSEPA {
    private static final SepaVersion DEFAULT = SepaVersion.PAIN_001_001_02;

    public GVTermMultiUebSEPA(HBCIPassportInternal passport) {
        this(passport, GVTermMultiUebSEPA.getLowlevelName(), (SepaVersion)null);
    }

    public GVTermMultiUebSEPA(HBCIPassportInternal passport, String name, SepaVersion sepaVersion) {
        super(passport, name, sepaVersion, new GVRPayment(passport));
        this.addConstraint("batchbook", "sepa.batchbook", "");
        this.addConstraint("Total.value", "Total.value", null);
        this.addConstraint("Total.curr", "Total.curr", null);
        this.addConstraint("date", "sepa.date", null);
    }

    public static String getLowlevelName() {
        return "TermSammelUebSEPA";
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }

    @Override
    public void verifyConstraints() {
        this.setParam("Total", SepaUtil.sumBtgValueObject(this.getPainParams()));
        super.verifyConstraints();
    }

    @Override
    public String getChallengeParam(String path) {
        if (path.equals("sepa.btg.value")) {
            return this.getLowlevelParam(this.getName() + ".Total.value");
        }
        if (path.equals("sepa.btg.curr")) {
            return this.getLowlevelParam(this.getName() + ".Total.curr");
        }
        return null;
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_001;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        String orderid = result.get(header + ".orderid");
        ((GVRPayment)this.jobResult).setOrderId(orderid);
    }
}

