/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV_Result.AbstractGVRLastSEPA;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public abstract class AbstractGVLastSEPA
extends AbstractSEPAGV {
    private static final SepaVersion DEFAULT = SepaVersion.PAIN_008_001_01;

    public AbstractGVLastSEPA(HBCIPassportInternal passport, String lowlevelName, SepaVersion sepaVersion, AbstractGVRLastSEPA result) {
        super(passport, lowlevelName, sepaVersion, result);
        this.addConstraint("src.bic", "My.bic", null);
        this.addConstraint("src.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("src.country", "My.KIK.country", "");
            this.addConstraint("src.blz", "My.KIK.blz", "");
            this.addConstraint("src.number", "My.number", "");
            this.addConstraint("src.subnumber", "My.subnumber", "");
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getSepaVersion().getURN());
        this.addConstraint("_sepapain", "sepapain", null);
        this.addConstraint("src.bic", "sepa.src.bic", null);
        this.addConstraint("src.iban", "sepa.src.iban", null);
        this.addConstraint("src.name", "sepa.src.name", null);
        this.addConstraint("dst.bic", "sepa.dst.bic", null, true);
        this.addConstraint("dst.iban", "sepa.dst.iban", null, true);
        this.addConstraint("dst.name", "sepa.dst.name", null, true);
        this.addConstraint("btg.value", "sepa.btg.value", null, true);
        this.addConstraint("btg.curr", "sepa.btg.curr", "EUR", true);
        this.addConstraint("usage", "sepa.usage", "", true);
        this.addConstraint("sepaid", "sepa.sepaid", this.getPainMessageId());
        this.addConstraint("pmtinfid", "sepa.pmtinfid", this.getPainMessageId());
        this.addConstraint("endtoendid", "sepa.endtoendid", "NOTPROVIDED", true);
        this.addConstraint("creditorid", "sepa.creditorid", null, true);
        this.addConstraint("mandateid", "sepa.mandateid", null, true);
        this.addConstraint("purposecode", "sepa.purposecode", "", true);
        this.addConstraint("manddateofsig", "sepa.manddateofsig", null, true);
        this.addConstraint("amendmandindic", "sepa.amendmandindic", Boolean.toString(false), true);
        this.addConstraint("sequencetype", "sepa.sequencetype", "FRST");
        this.addConstraint("targetdate", "sepa.targetdate", "1999-01-01");
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_008;
    }

    @Override
    public String getPainJobName() {
        return "LastSEPA";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        String orderid = result.get(header + ".orderid");
        ((AbstractGVRLastSEPA)this.jobResult).setOrderId(orderid);
        if (orderid != null && orderid.length() != 0) {
            HashMap p2 = new HashMap();
            this.getLowlevelParams().forEach((key, value) -> p2.put(key.substring(key.indexOf(".") + 1), value));
        }
    }
}

