/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.structures;

import java.io.Serializable;
import java.math.BigDecimal;
import org.kapott.hbci.manager.HBCIUtils;

public final class Value
implements Serializable {
    private static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");
    private long value;
    private String curr;

    public Value() {
        this(0L, "EUR");
    }

    @Deprecated
    public Value(double value) {
        this(Math.round(100.0 * value), "EUR");
    }

    public Value(long value) {
        this(value, "EUR");
    }

    public Value(String value) {
        this(value, "EUR");
    }

    public Value(BigDecimal value) {
        this(value, "EUR");
    }

    public Value(String value, String curr) {
        this(new BigDecimal(value.replace(" ", "")), curr);
    }

    @Deprecated
    public Value(double value, String curr) {
        this(Math.round(100.0 * value), curr);
    }

    public Value(long value, String curr) {
        this.value = value;
        this.curr = curr;
    }

    public Value(BigDecimal value, String curr) {
        this.value = value.multiply(ONE_HUNDRED).longValueExact();
        this.curr = curr;
    }

    public Value(Value v) {
        this(v.value, v.curr);
    }

    public String toString() {
        return HBCIUtils.bigDecimal2String(new BigDecimal(this.value).divide(ONE_HUNDRED)) + " " + this.curr;
    }

    public long getLongValue() {
        return this.value;
    }

    @Deprecated
    public double getDoubleValue() {
        return (double)this.value / 100.0;
    }

    public BigDecimal getBigDecimalValue() {
        BigDecimal result = new BigDecimal(this.value).divide(ONE_HUNDRED);
        result.setScale(2, 6);
        return result;
    }

    public String getCurr() {
        return this.curr;
    }

    public void setCurr(String curr) {
        this.curr = curr;
    }

    public void setValue(double value) {
        this.setValue(Math.round(100.0 * value));
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setValue(BigDecimal value) {
        this.value = value.multiply(ONE_HUNDRED).longValueExact();
    }
}

