/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.security;

import java.util.Date;
import java.util.List;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MessageFactory;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SEG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Crypt {
    private static final Logger log = LoggerFactory.getLogger(Crypt.class);
    public static final String SECFUNC_ENC_3DES = "4";
    public static final String SECFUNC_ENC_PLAIN = "998";
    public static final String ENCALG_2K3DES = "13";
    public static final String ENCMODE_CBC = "2";
    public static final String ENCMODE_PKCS1 = "18";
    public static final String ENC_KEYTYPE_RSA = "6";
    public static final String ENC_KEYTYPE_DDV = "5";
    private HBCIPassportInternal passport;
    private String u_secfunc;
    private String u_keytype;
    private String u_blz;
    private String u_country;
    private String u_keyuserid;
    private String u_keynum;
    private String u_keyversion;
    private String u_cid;
    private String u_sysId;
    private String u_role;
    private String u_alg;
    private String u_mode;
    private String u_compfunc;

    public Crypt(HBCIPassportInternal passport) {
        this.passport = passport;
        this.init();
    }

    private void init() {
        this.u_secfunc = this.passport.getCryptFunction();
        this.u_keytype = this.passport.getCryptKeyType();
        this.u_blz = this.passport.getBLZ();
        this.u_country = this.passport.getCountry();
        this.u_keyuserid = this.passport.getInstEncKeyName();
        this.u_keynum = this.passport.getInstEncKeyNum();
        this.u_keyversion = this.passport.getInstEncKeyVersion();
        this.u_cid = "";
        this.u_sysId = this.passport.getSysId();
        this.u_role = "1";
        this.u_alg = this.passport.getCryptAlg();
        this.u_mode = this.passport.getCryptMode();
        this.u_compfunc = "0";
    }

    public Message cryptIt(Message msg) {
        Message newmsg = msg;
        if (this.passport.hasInstEncKey()) {
            Node msgNode = this.passport.getSyntaxDef(msg.getName());
            String dontcryptAttr = ((Element)msgNode).getAttribute("dontcrypt");
            if (dontcryptAttr.length() == 0) {
                newmsg = MessageFactory.createMessage("Crypted", this.passport.getSyntaxDocument());
                try {
                    byte[][] crypteds = this.passport.encrypt(msg.getPlainString());
                    String msgPath = msg.getPath();
                    String dialogid = msg.getValueOfDE(msgPath + ".MsgHead.dialogid");
                    String msgnum = msg.getValueOfDE(msgPath + ".MsgHead.msgnum");
                    String segnum = msg.getValueOfDE(msgPath + ".MsgTail.SegHead.seq");
                    Date d = new Date();
                    newmsg.set("Crypted.CryptData.data", "B" + new String(crypteds[1], CommPinTan.ENCODING));
                    newmsg.set("Crypted.CryptHead.CryptAlg.alg", this.u_alg);
                    newmsg.set("Crypted.CryptHead.CryptAlg.mode", this.u_mode);
                    newmsg.set("Crypted.CryptHead.CryptAlg.enckey", "B" + new String(crypteds[0], CommPinTan.ENCODING));
                    newmsg.set("Crypted.CryptHead.CryptAlg.keytype", this.u_keytype);
                    newmsg.set("Crypted.CryptHead.SecIdnDetails.func", newmsg.getName().endsWith("Res") ? ENCMODE_CBC : "1");
                    newmsg.set("Crypted.CryptHead.KeyName.KIK.blz", this.u_blz);
                    newmsg.set("Crypted.CryptHead.KeyName.KIK.country", this.u_country);
                    newmsg.set("Crypted.CryptHead.KeyName.userid", this.u_keyuserid);
                    newmsg.set("Crypted.CryptHead.KeyName.keynum", this.u_keynum);
                    newmsg.set("Crypted.CryptHead.KeyName.keyversion", this.u_keyversion);
                    newmsg.set("Crypted.CryptHead.SecProfile.method", this.passport.getProfileMethod());
                    newmsg.set("Crypted.CryptHead.SecProfile.version", this.passport.getProfileVersion());
                    if (this.passport.getSysStatus().equals("0")) {
                        newmsg.set("Crypted.CryptHead.SecIdnDetails.cid", "B" + this.u_cid);
                    } else {
                        newmsg.set("Crypted.CryptHead.SecIdnDetails.sysid", this.u_sysId);
                    }
                    newmsg.set("Crypted.CryptHead.SecTimestamp.date", HBCIUtils.date2StringISO(d));
                    newmsg.set("Crypted.CryptHead.SecTimestamp.time", HBCIUtils.time2StringISO(d));
                    newmsg.set("Crypted.CryptHead.role", this.u_role);
                    newmsg.set("Crypted.CryptHead.secfunc", this.u_secfunc);
                    newmsg.set("Crypted.CryptHead.compfunc", this.u_compfunc);
                    newmsg.set("Crypted.MsgHead.dialogid", dialogid);
                    newmsg.set("Crypted.MsgHead.msgnum", msgnum);
                    newmsg.set("Crypted.MsgTail.msgnum", msgnum);
                    newmsg.complete();
                    for (int i = 1; i <= 2; ++i) {
                        SEG seg = (SEG)newmsg.getChildContainers().get(i).getElements().get(0);
                        seg.setSeq(997 + i, true);
                    }
                    newmsg.propagateValue(newmsg.getPath() + ".MsgTail.SegHead.seq", segnum, false, true);
                    newmsg.autoSetMsgSize();
                }
                catch (Exception ex) {
                    throw new HBCI_Exception("*** error while encrypting", ex);
                }
            } else {
                log.debug("did not encrypt - message does not want to be encrypted");
            }
        } else {
            log.warn("can not encrypt - no encryption key available");
        }
        return newmsg;
    }

    public String decryptIt(Message message) {
        if (message.isCrypted()) {
            try {
                String msgName = message.getName();
                List<MultipleSyntaxElements> childs = message.getChildContainers();
                SEG msghead = (SEG)childs.get(0).getElements().get(0);
                SEG msgtail = (SEG)childs.get(childs.size() - 1).getElements().get(0);
                SEG cryptdata = (SEG)childs.get(2).getElements().get(0);
                byte[] cryptedstring = cryptdata.getValueOfDE(msgName + ".CryptData.data").getBytes(CommPinTan.ENCODING);
                SEG crypthead = (SEG)childs.get(1).getElements().get(0);
                byte[] cryptedkey = crypthead.getValueOfDE(msgName + ".CryptHead.CryptAlg.enckey").getBytes(CommPinTan.ENCODING);
                String secfunc = crypthead.getValueOfDE(msgName + ".CryptHead.secfunc");
                if (!secfunc.equals(this.passport.getCryptFunction())) {
                    String errmsg = HBCIUtils.getLocMsg("EXCMSG_CRYPTSFFAIL", new Object[]{secfunc, this.passport.getCryptFunction()});
                    throw new HBCI_Exception(errmsg);
                }
                String compfunc = crypthead.getValueOfDE(msgName + ".CryptHead.compfunc");
                if (!compfunc.equals("0")) {
                    String errmsg = HBCIUtils.getLocMsg("EXCMSG_CRYPTCOMPFUNCFAIL", compfunc);
                    throw new HBCI_Exception(errmsg);
                }
                byte[] plainMsg = this.passport.decrypt(cryptedkey, cryptedstring);
                byte padLength = plainMsg[plainMsg.length - 1];
                StringBuffer ret = new StringBuffer(1024);
                ret.append(msghead.toString(0)).append(new String(plainMsg, 0, plainMsg.length - padLength, CommPinTan.ENCODING)).append(msgtail.toString(0));
                log.debug("decrypted message: " + ret);
                return ret.toString();
            }
            catch (Exception ex) {
                throw new HBCI_Exception("*** error while decrypting", ex);
            }
        }
        log.debug("did not decrypt - message is already cleartext");
        return message.toString(0);
    }
}

