/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.lang.reflect.Constructor;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBCIJobFactory {
    private static final Logger log = LoggerFactory.getLogger(HBCIJobFactory.class);

    public static AbstractHBCIJob newJob(String jobname, HBCIPassportInternal passport) {
        log.debug("creating new job " + jobname);
        if (jobname == null || jobname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        AbstractHBCIJob ret = null;
        String className = "org.kapott.hbci.GV.GV" + jobname;
        try {
            Class<?> cl = Class.forName(className);
            Constructor<?> cons = cl.getConstructor(HBCIPassportInternal.class);
            ret = (AbstractHBCIJob)cons.newInstance(passport);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidUserDataException("*** there is no highlevel job named " + jobname + " - need class " + className);
        }
        catch (Exception e) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_JOB_CREATE_ERR", jobname);
            throw new HBCI_Exception(msg, e);
        }
        return ret;
    }
}

