/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MessageFactory;
import org.w3c.dom.Document;

public final class DocumentFactory {
    public static Document createDocument(String hbciversion) {
        Document document;
        block10: {
            String filename = "hbci-" + hbciversion + ".xml";
            InputStream syntaxStream = MessageFactory.class.getClassLoader().getResourceAsStream(filename);
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setIgnoringComments(true);
                dbf.setValidating(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                document = db.parse(syntaxStream);
                if (syntaxStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (syntaxStream != null) {
                        try {
                            syntaxStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FactoryConfigurationError e) {
                    throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_MSGGEN_DBFAC"), e);
                }
                catch (ParserConfigurationException e) {
                    throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_MSGGEN_DB"), e);
                }
                catch (Exception e) {
                    throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_MSGGEN_STXFILE"), e);
                }
            }
            syntaxStream.close();
        }
        return document;
    }
}

