/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.generators.AbstractSEPAGenerator;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.AccountIdentification4Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.ActiveOrHistoricCurrencyCodeEUR;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.AmountType4Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.BranchAndFinancialInstitutionIdentification5;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.BranchAndFinancialInstitutionIdentification5Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.CashAccount38;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.CashAccount382;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.ChargeBearerTypeSEPACode;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.CreditTransferTransaction34;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.CustomerCreditTransferInitiationV09;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.DateAndDateTimeChoice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.Document;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.FinancialInstitutionIdentification8;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.FinancialInstitutionIdentification8Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.GroupHeader85;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.LocalInstrumentSEPA;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.ObjectFactory;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.OthrIdentification;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.OthrIdentificationCode;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PartyIdentification1351;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PartyIdentification1352;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PaymentIdentification6;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PaymentInstruction30;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PaymentMethod3Code;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.PaymentTypeInformation261;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.Purpose2Choice;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.RemittanceInformation11;
import org.kapott.hbci.sepa.jaxb.pain_001_001_09.ServiceLevel8Choice;

public class GenUebSEPA00100109
extends AbstractSEPAGenerator<Map<String, String>> {
    @Override
    public void generate(Map<String, String> sepaParams, OutputStream os, boolean validate) {
        Integer maxIndex = SepaUtil.maxIndex(sepaParams);
        Document doc = new Document();
        doc.setCstmrCdtTrfInitn(new CustomerCreditTransferInitiationV09());
        doc.getCstmrCdtTrfInitn().setGrpHdr(new GroupHeader85());
        String sepaId = sepaParams.get("sepaid");
        String pmtInfId = sepaParams.get("pmtinfid");
        doc.getCstmrCdtTrfInitn().getGrpHdr().setMsgId(sepaId);
        doc.getCstmrCdtTrfInitn().getGrpHdr().setCreDtTm(SepaUtil.createCalendar(null));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setNbOfTxs(String.valueOf(maxIndex != null ? maxIndex + 1 : 1));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setInitgPty(new PartyIdentification1351());
        doc.getCstmrCdtTrfInitn().getGrpHdr().getInitgPty().setNm(sepaParams.get("src.name"));
        doc.getCstmrCdtTrfInitn().getGrpHdr().setCtrlSum(SepaUtil.sumBtgValue(sepaParams, maxIndex));
        ArrayList pmtInfs = (ArrayList)doc.getCstmrCdtTrfInitn().getPmtInf();
        PaymentInstruction30 pmtInf = new PaymentInstruction30();
        pmtInfs.add(pmtInf);
        pmtInf.setPmtInfId(pmtInfId != null && pmtInfId.length() > 0 ? pmtInfId : sepaId);
        pmtInf.setPmtMtd(PaymentMethod3Code.TRF);
        pmtInf.setNbOfTxs(String.valueOf(maxIndex != null ? maxIndex + 1 : 1));
        pmtInf.setCtrlSum(SepaUtil.sumBtgValue(sepaParams, maxIndex));
        pmtInf.setPmtTpInf(new PaymentTypeInformation261());
        pmtInf.getPmtTpInf().setSvcLvl(new ServiceLevel8Choice());
        pmtInf.getPmtTpInf().getSvcLvl().setCd("SEPA");
        pmtInf.getPmtTpInf().setLclInstrm(new LocalInstrumentSEPA());
        pmtInf.getPmtTpInf().getLclInstrm().setCd(sepaParams.get("LclInstrm"));
        String date = sepaParams.get("date");
        if (date == null) {
            date = "1999-01-01";
        }
        DateAndDateTimeChoice dateAndDateTimeChoice = new DateAndDateTimeChoice();
        dateAndDateTimeChoice.setDt(SepaUtil.createCalendar(date));
        pmtInf.setReqdExctnDt(dateAndDateTimeChoice);
        pmtInf.setDbtr(new PartyIdentification1352());
        pmtInf.setDbtrAcct(new CashAccount38());
        pmtInf.setDbtrAgt(new BranchAndFinancialInstitutionIdentification5Choice());
        pmtInf.getDbtr().setNm(sepaParams.get("src.name"));
        pmtInf.getDbtrAcct().setId(new AccountIdentification4Choice());
        pmtInf.getDbtrAcct().getId().setIBAN(sepaParams.get("src.iban"));
        pmtInf.getDbtrAgt().setFinInstnId(new FinancialInstitutionIdentification8Choice());
        String srcBic = sepaParams.get("src.bic");
        if (srcBic != null && srcBic.length() > 0) {
            pmtInf.getDbtrAgt().getFinInstnId().setBICFI(srcBic);
        } else {
            pmtInf.getDbtrAgt().getFinInstnId().setOthr(new OthrIdentification());
            pmtInf.getDbtrAgt().getFinInstnId().getOthr().setId(OthrIdentificationCode.NOTPROVIDED);
        }
        pmtInf.setChrgBr(ChargeBearerTypeSEPACode.SLEV);
        ArrayList cdtTrxTxInfs = (ArrayList)pmtInf.getCdtTrfTxInf();
        if (maxIndex != null) {
            for (int tnr = 0; tnr <= maxIndex; ++tnr) {
                cdtTrxTxInfs.add(this.createCreditTransferTransaction34(sepaParams, tnr));
            }
        } else {
            cdtTrxTxInfs.add(this.createCreditTransferTransaction34(sepaParams, null));
        }
        String batch = SepaUtil.getProperty(sepaParams, "batchbook", null);
        if (batch != null) {
            pmtInf.setBtchBookg(batch.equals("1"));
        }
        ObjectFactory of = new ObjectFactory();
        try {
            this.marshal(of.createDocument(doc), os, validate);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private CreditTransferTransaction34 createCreditTransferTransaction34(Map<String, String> sepaParams, Integer index) {
        String purposeCode;
        CreditTransferTransaction34 cdtTrxTxInf = new CreditTransferTransaction34();
        cdtTrxTxInf.setPmtId(new PaymentIdentification6());
        cdtTrxTxInf.getPmtId().setEndToEndId(SepaUtil.getProperty(sepaParams, SepaUtil.insertIndex("endtoendid", index), "NOTPROVIDED"));
        cdtTrxTxInf.setCdtr(new PartyIdentification1352());
        cdtTrxTxInf.getCdtr().setNm(sepaParams.get(SepaUtil.insertIndex("dst.name", index)));
        cdtTrxTxInf.setCdtrAcct(new CashAccount382());
        cdtTrxTxInf.getCdtrAcct().setId(new AccountIdentification4Choice());
        cdtTrxTxInf.getCdtrAcct().getId().setIBAN(sepaParams.get(SepaUtil.insertIndex("dst.iban", index)));
        String dstBic = sepaParams.get(SepaUtil.insertIndex("dst.bic", index));
        if (dstBic != null && dstBic.length() > 0) {
            cdtTrxTxInf.setCdtrAgt(new BranchAndFinancialInstitutionIdentification5());
            cdtTrxTxInf.getCdtrAgt().setFinInstnId(new FinancialInstitutionIdentification8());
            cdtTrxTxInf.getCdtrAgt().getFinInstnId().setBICFI(dstBic);
        }
        cdtTrxTxInf.setAmt(new AmountType4Choice());
        cdtTrxTxInf.getAmt().setInstdAmt(new ActiveOrHistoricCurrencyAndAmount());
        cdtTrxTxInf.getAmt().getInstdAmt().setValue(new BigDecimal(sepaParams.get(SepaUtil.insertIndex("btg.value", index))));
        cdtTrxTxInf.getAmt().getInstdAmt().setCcy(ActiveOrHistoricCurrencyCodeEUR.EUR);
        String usage = sepaParams.get(SepaUtil.insertIndex("usage", index));
        if (usage != null && usage.length() > 0) {
            cdtTrxTxInf.setRmtInf(new RemittanceInformation11());
            cdtTrxTxInf.getRmtInf().setUstrd(usage);
        }
        if ((purposeCode = sepaParams.get(SepaUtil.insertIndex("purposecode", index))) != null && purposeCode.length() > 0) {
            Purpose2Choice p = new Purpose2Choice();
            p.setCd(purposeCode);
            cdtTrxTxInf.setPurp(p);
        }
        return cdtTrxTxInf;
    }

    @Override
    public SepaVersion getSepaVersion() {
        return SepaVersion.PAIN_001_001_09;
    }
}

