/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Optional;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVRawSEPA
extends AbstractSEPAGV {
    private static final SepaVersion DEFAULT = SepaVersion.PAIN_001_001_02;

    public GVRawSEPA(HBCIPassportInternal passport) {
        this(passport, GVRawSEPA.getLowlevelName(), (String)null);
    }

    public GVRawSEPA(HBCIPassportInternal passport, String name, String pain) {
        super(passport, name);
        this.addConstraint("src.bic", "My.bic", null);
        this.addConstraint("src.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("src.country", "My.KIK.country", "");
            this.addConstraint("src.blz", "My.KIK.blz", "");
            this.addConstraint("src.number", "My.number", "");
            this.addConstraint("src.subnumber", "My.subnumber", "");
        }
        if (pain == null) {
            this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN());
            this.addConstraint("_sepapain", "sepapain", null);
        } else {
            this.setPainVersion(SepaVersion.autodetect(pain).getURN());
            this.setPainXml("B" + pain);
        }
        this.addConstraint("firstdate", "DauerDetails.firstdate", "");
        this.addConstraint("timeunit", "DauerDetails.timeunit", "");
        this.addConstraint("turnus", "DauerDetails.turnus", "");
        this.addConstraint("execday", "DauerDetails.execday", "");
        this.addConstraint("lastdate", "DauerDetails.lastdate", "");
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Optional.ofNullable(msgstatus.getData().get(header + ".orderid")).ifPresent(orderid -> this.jobResult.getResultData().put("orderid", (String)orderid));
    }

    public static String getLowlevelName() {
        return "RawSEPA";
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_001;
    }

    @Override
    public String getPainJobName() {
        return null;
    }
}

