/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.CanNotParseMessageException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.rewrite.Rewrite;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommPinTan {
    private static final Logger log = LoggerFactory.getLogger(CommPinTan.class);
    public static final Charset ENCODING = StandardCharsets.ISO_8859_1;
    private static final int HTTP_CONNECT_TIMEOUT = 60000;
    private static final int HTTP_READ_TIMEOUT = 300000;
    private HBCICallback callback;
    private URL url;
    private HttpURLConnection conn;

    public CommPinTan(String host, HBCICallback callback) {
        this.callback = callback;
        try {
            log.info("connect: " + host);
            this.url = new URL(host);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CONNERR"), e);
        }
    }

    public CommPinTan withProxy(String proxyHost, final String proxyUser, final String proxyPass) {
        String[] proxyData;
        if (proxyHost != null && (proxyData = proxyHost.split(":")).length == 2) {
            log.info("HTTPS connections will be made using proxy " + proxyData[0] + "(Port " + proxyData[1] + ")");
            Properties sysProps = System.getProperties();
            sysProps.put("https.proxyHost", proxyData[0]);
            sysProps.put("https.proxyPort", proxyData[1]);
            log.debug("initializing HBCI4Java proxy authentication callback");
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
                }
            });
        }
        return this;
    }

    public Message pingpong(Message message, String messageName, List<Rewrite> rewriters, HBCIMsgStatus msgStatus) {
        log.trace("---------------- request ----------------");
        String rawMsg = message.toString(0);
        if (log.isTraceEnabled()) {
            Arrays.stream(rawMsg.split("'")).forEach(arg_0 -> ((Logger)log).trace(arg_0));
        }
        this.callback.status(24, null);
        this.callback.status(30, rawMsg);
        this.ping(message);
        this.callback.status(27, null);
        rawMsg = this.pong();
        this.callback.status(31, rawMsg);
        log.trace("---------------- response ----------------");
        if (log.isTraceEnabled()) {
            Arrays.stream(rawMsg.split("'")).forEach(arg_0 -> ((Logger)log).trace(arg_0));
        }
        try {
            for (Rewrite rewriter1 : rewriters) {
                rawMsg = rewriter1.incomingCrypted(rawMsg, msgStatus, messageName);
            }
            return this.parseResponseMessage(message, rawMsg, rewriters);
        }
        catch (Exception ex) {
            throw new CanNotParseMessageException(HBCIUtils.getLocMsg("EXCMSG_CANTPARSE"), rawMsg, ex);
        }
    }

    private Message parseResponseMessage(Message inputMessage, String rawResponse, List<Rewrite> rewriters) {
        Message responseMessage;
        this.callback.status(28, "CryptedRes");
        try {
            log.trace("trying to parse message as crypted message");
            responseMessage = new Message("CryptedRes", rawResponse, inputMessage.getDocument(), false, true);
        }
        catch (ParseErrorException e) {
            log.trace("message seems not to be encrypted; tring to parse it as " + inputMessage.getName() + "Res " + inputMessage);
            for (Rewrite rewriter1 : rewriters) {
                rawResponse = rewriter1.incomingClearText(rawResponse);
            }
            log.trace(rawResponse);
            this.callback.status(28, inputMessage.getName() + "Res");
            try {
                responseMessage = new Message(inputMessage.getName() + "Res", rawResponse, inputMessage.getDocument(), true, true);
            }
            catch (ParseErrorException e2) {
                responseMessage = new Message("ErrorRes", rawResponse, inputMessage.getDocument(), true, true);
            }
        }
        return responseMessage;
    }

    private void ping(Message msg) {
        try {
            byte[] b = Base64.encodeBase64((byte[])msg.toString(0).getBytes(ENCODING));
            this.conn = (HttpURLConnection)this.url.openConnection();
            this.conn.setConnectTimeout(60000);
            this.conn.setReadTimeout(300000);
            this.conn.setDoOutput(true);
            this.conn.setRequestMethod("POST");
            this.conn.setRequestProperty("Content-Type", "application/octet-stream");
            this.conn.setFixedLengthStreamingMode(b.length);
            this.conn.connect();
            OutputStream out = this.conn.getOutputStream();
            out.write(b);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            HBCI_Exception he = new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SENDERR"), e);
            he.setFatal(true);
            throw he;
        }
    }

    private String pong() {
        try {
            int n;
            byte[] b = new byte[1024];
            InputStream input = this.conn.getInputStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while (-1 != (n = input.read(b))) {
                output.write(b, 0, n);
            }
            this.conn.disconnect();
            return new String(Base64.decodeBase64((byte[])output.toByteArray()), ENCODING);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_RECVERR"), e);
        }
    }
}

