/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.BigDecimalValue;
import org.kapott.hbci.structures.Konto;

public final class GVRWPDepotList
extends HBCIJobResultImpl {
    public String rest;
    private List<Entry> entries = new ArrayList<Entry>();

    public GVRWPDepotList(HBCIPassportInternal passport) {
        super(passport);
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    public Entry[] getEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.get(i);
            ret.append("Entry #").append(i).append(":").append(linesep);
            ret.append(e.toString() + linesep + linesep);
        }
        ret.append("rest: ").append(this.rest);
        return ret.toString().trim();
    }

    public static final class Entry {
        public static final int SALDO_TYPE_STCK = 1;
        public static final int SALDO_TYPE_WERT = 2;
        public Date timestamp;
        public Konto depot;
        public BigDecimalValue total;
        private ArrayList<Gattung> gattungen = new ArrayList();

        public void addEntry(Gattung gattung) {
            this.gattungen.add(gattung);
        }

        public Gattung[] getEntries() {
            return this.gattungen.toArray(new Gattung[this.gattungen.size()]);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            DateFormat df = DateFormat.getDateTimeInstance(3, 3, HBCIUtils.getLocale());
            ret.append("Depot ").append(this.depot.toString()).append(" ").append(df.format(this.timestamp)).append(linesep);
            for (int i = 0; i < this.gattungen.size(); ++i) {
                ret.append("Gattung:").append(linesep);
                ret.append(this.gattungen.get(i).toString() + linesep + linesep);
            }
            if (this.total != null) {
                ret.append("Total: ").append(this.total.toString());
            }
            return ret.toString().trim();
        }

        public static final class Gattung {
            public static final int PRICE_TYPE_PRCT = 1;
            public static final int PRICE_TYPE_VALUE = 2;
            public static final int PRICE_QUALIF_MRKT = 1;
            public static final int PRICE_QUALIF_HINT = 2;
            public static final int SOURCE_LOC = 1;
            public static final int SOURCE_THEOR = 2;
            public static final int SOURCE_SELLER = 3;
            public String isin;
            public String wkn;
            public String name;
            public int pricetype;
            public int pricequalifier;
            public BigDecimalValue price;
            public int source;
            public String source_comment;
            public Date timestamp_price;
            public int saldo_type;
            public BigDecimalValue saldo;
            public int days;
            public BigDecimalValue depotwert;
            public BigDecimalValue stueckzinsbetrag;
            public String xchg_cur1;
            public String xchg_cur2;
            public double xchg_kurs;
            public String curr;
            public String wptype;
            public String branche;
            public String countryEmittent;
            public Date kauf;
            public Date faellig;
            public BigDecimalValue einstandspreis;
            public long zinssatz;
            public int kontrakttype;
            public Date kontraktverfall;
            public int kontraktversion;
            public int kontraktsize;
            public String symbol;
            public String underlyingwkn;
            public String underlyingisin;
            public BigDecimalValue kontraktbasispreis;
            private ArrayList<SubSaldo> saldi = new ArrayList();

            public void addSubSaldo(SubSaldo subsaldo) {
                this.saldi.add(subsaldo);
            }

            public SubSaldo[] getEntries() {
                return this.saldi.toArray(new SubSaldo[this.saldi.size()]);
            }

            public String toString() {
                StringBuffer ret = new StringBuffer();
                String linesep = System.getProperty("line.separator");
                ret.append("Gattung ").append(this.name).append("(ISIN:");
                ret.append(this.isin).append(" WKN:").append(this.wkn);
                ret.append(" CURR:").append(this.curr).append(")").append(linesep);
                if (this.price != null) {
                    ret.append("Preis: ").append(this.price.toString()).append(" (").append(this.pricetype == 1 ? "Prozent" : "Betrag");
                    ret.append("; ").append(this.pricequalifier == 1 ? "Marktpreis" : "Hinweispreis").append(")").append(linesep);
                }
                if (this.source != 0) {
                    ret.append("Quelle: ");
                    switch (this.source) {
                        case 1: {
                            ret.append("lokale Boerse");
                            break;
                        }
                        case 2: {
                            ret.append("theoretischer Wert");
                            break;
                        }
                        case 3: {
                            ret.append("Verkaeufer");
                            break;
                        }
                        default: {
                            ret.append("(unknown)");
                        }
                    }
                    if (this.source_comment != null) {
                        ret.append(" (").append(this.source_comment).append(")");
                    }
                    ret.append(linesep);
                }
                if (this.timestamp_price != null) {
                    DateFormat df = DateFormat.getDateTimeInstance(3, 3, HBCIUtils.getLocale());
                    ret.append("Zeitpunkt: ").append(df.format(this.timestamp_price)).append(linesep);
                }
                if (this.depotwert != null) {
                    ret.append("Depotwert: ").append(this.depotwert.toString()).append(linesep);
                }
                if (this.stueckzinsbetrag != null) {
                    ret.append("Stueckzins: ").append(this.stueckzinsbetrag.toString()).append(linesep);
                }
                if (this.einstandspreis != null) {
                    ret.append("Einstandspreis: ").append(this.einstandspreis.toString()).append(linesep);
                }
                if (this.zinssatz != 0L) {
                    ret.append("Zinssatz: ").append(HBCIUtils.bigDecimal2String(new BigDecimal(this.zinssatz).divide(new BigDecimal("1000.0")))).append(linesep);
                }
                ret.append("Typ:").append(this.wptype).append(" Branche:").append(this.branche).append(" Emittent:").append(this.countryEmittent).append(linesep);
                if (this.kauf != null) {
                    ret.append("Kauf: ").append(HBCIUtils.date2StringLocal(this.kauf)).append(linesep);
                }
                if (this.faellig != null) {
                    ret.append("Faelligkeit: ").append(HBCIUtils.date2StringLocal(this.faellig)).append(linesep);
                }
                if (this.days != 0) {
                    ret.append("Anzahl abgelaufener Tage: ").append(this.days).append(linesep);
                }
                ret.append("Saldo: ").append(this.saldo.toString());
                ret.append(" (").append(this.saldo_type == 1 ? "STCK" : "WERT");
                ret.append(")").append(linesep);
                for (int i = 0; i < this.saldi.size(); ++i) {
                    ret.append("SubSaldo:").append(linesep);
                    ret.append(this.saldi.get(i).toString());
                    if (i >= this.saldi.size() - 1) continue;
                    ret.append(linesep + linesep);
                }
                return ret.toString().trim();
            }

            public static final class SubSaldo {
                public String qualifier;
                public int saldo_type;
                public boolean locked;
                public BigDecimalValue saldo;
                public String country;
                public int verwahrung;
                public String lager;
                public Date lockeduntil;
                public String comment;

                public String toString() {
                    StringBuffer ret = new StringBuffer();
                    String linesep = System.getProperty("line.separator");
                    ret.append(this.qualifier).append(": ");
                    ret.append(this.saldo.toString()).append(" (").append(this.saldo_type == 1 ? "STCK" : "WERT").append(")").append(linesep);
                    ret.append("Lagerland: ").append(this.country + linesep);
                    ret.append("Verwahrung Typ: ").append(this.verwahrung).append(linesep);
                    ret.append("Lager: ").append(this.lager).append(linesep);
                    if (this.locked) {
                        ret.append("locked");
                        if (this.lockeduntil != null) {
                            DateFormat df = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
                            ret.append(" until ").append(df.format(this.lockeduntil));
                        }
                    } else {
                        ret.append("not locked");
                    }
                    if (this.comment != null) {
                        ret.append(linesep).append("Bemerkungen: ").append(this.comment);
                    }
                    return ret.toString().trim();
                }
            }
        }
    }
}

