/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRTermUebList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVTermUebList
extends AbstractHBCIJob {
    public GVTermUebList(HBCIPassportInternal passport) {
        super(passport, GVTermUebList.getLowlevelName(), new GVRTermUebList(passport));
        this.addConstraint("my.country", "KTV.KIK.country", "DE");
        this.addConstraint("my.blz", "KTV.KIK.blz", null);
        this.addConstraint("my.number", "KTV.number", null);
        this.addConstraint("my.subnumber", "KTV.subnumber", "");
        this.addConstraint("startdate", "startdate", "");
        this.addConstraint("enddate", "enddate", "");
        this.addConstraint("maxentries", "maxentries", "");
    }

    public static String getLowlevelName() {
        return "TermUebList";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String usage;
        HashMap<String, String> result = msgstatus.getData();
        GVRTermUebList.Entry entry = new GVRTermUebList.Entry();
        entry.my = new Konto();
        entry.my.blz = result.get(header + ".My.KIK.blz");
        entry.my.country = result.get(header + ".My.KIK.country");
        entry.my.number = result.get(header + ".My.number");
        entry.my.subnumber = result.get(header + ".My.subnumber");
        this.passport.fillAccountInfo(entry.my);
        entry.other = new Konto();
        entry.other.blz = result.get(header + ".Other.KIK.blz");
        entry.other.country = result.get(header + ".Other.KIK.country");
        entry.other.number = result.get(header + ".Other.number");
        entry.other.subnumber = result.get(header + ".Other.subnumber");
        entry.other.name = result.get(header + ".name");
        entry.other.name2 = result.get(header + ".name2");
        this.passport.fillAccountInfo(entry.other);
        entry.key = result.get(header + ".key");
        entry.addkey = result.get(header + ".addkey");
        entry.orderid = result.get(header + ".id");
        entry.date = HBCIUtils.string2DateISO(result.get(header + ".date"));
        entry.value = new Value(result.get(header + ".BTG.value"), result.get(header + ".BTG.curr"));
        int i = 0;
        while ((usage = result.get(HBCIUtils.withCounter(header + ".usage.usage", i))) != null) {
            entry.addUsage(usage);
            ++i;
        }
        ((GVRTermUebList)this.jobResult).addEntry(entry);
        if (entry.orderid != null && entry.orderid.length() != 0) {
            HashMap p2 = new HashMap();
            p2.keySet().forEach(key -> {
                if (key.startsWith(header + ".") && !key.startsWith(header + ".SegHead.") && !key.endsWith(".id")) {
                    p2.put(key.substring(header.length() + 1), (String)result.get(key));
                }
            });
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

