/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.manager.KnownReturncode;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVTAN2Step
extends AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(GVTAN2Step.class);
    private AbstractHBCIJob scaJob;
    private AbstractHBCIJob redo;
    private KnownTANProcess process = null;

    public GVTAN2Step(HBCIPassportInternal passport, AbstractHBCIJob scaJob) {
        super(passport, GVTAN2Step.getLowlevelName(), new GVRSaldoReq(passport));
        this.scaJob = scaJob;
        this.addConstraint("process", "process", null);
        this.addConstraint("ordersegcode", "ordersegcode", "");
        this.addConstraint("orderhash", "orderhash", "");
        this.addConstraint("orderref", "orderref", "");
        this.addConstraint("listidx", "listidx", "");
        this.addConstraint("notlasttan", "notlasttan", "N");
        this.addConstraint("info", "info", "");
        this.addConstraint("tanmedia", "tanmedia", "");
        this.addConstraint("storno", "storno", "");
        this.addConstraint("challengeklass", "challengeklass", "");
        this.addConstraint("ChallengeKlassParam1", "ChallengeKlassParams.param1", "");
        this.addConstraint("ChallengeKlassParam2", "ChallengeKlassParams.param2", "");
        this.addConstraint("ChallengeKlassParam3", "ChallengeKlassParams.param3", "");
        this.addConstraint("ChallengeKlassParam4", "ChallengeKlassParams.param4", "");
        this.addConstraint("ChallengeKlassParam5", "ChallengeKlassParams.param5", "");
        this.addConstraint("ChallengeKlassParam6", "ChallengeKlassParams.param6", "");
        this.addConstraint("ChallengeKlassParam7", "ChallengeKlassParams.param7", "");
        this.addConstraint("ChallengeKlassParam8", "ChallengeKlassParams.param8", "");
        this.addConstraint("ChallengeKlassParam9", "ChallengeKlassParams.param9", "");
        this.addConstraint("orderaccount.bic", "OrderAccount.bic", null);
        this.addConstraint("orderaccount.iban", "OrderAccount.iban", null);
        this.addConstraint("orderaccount.number", "OrderAccount.number", null);
        this.addConstraint("orderaccount.subnumber", "OrderAccount.subnumber", "");
        this.addConstraint("orderaccount.blz", "OrderAccount.KIK.blz", null);
        this.addConstraint("orderaccount.country", "OrderAccount.KIK.country", "DE");
    }

    public static String getLowlevelName() {
        return "TAN2Step";
    }

    public void setProcess(KnownTANProcess p) {
        this.process = p;
        this.setParam("process", p.getCode());
    }

    @Override
    public void setParam(String paramName, String value) {
        if (paramName.equals("orderhash")) {
            value = "B" + (String)value;
        }
        super.setParam(paramName, (String)value);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        String segCode = result.get(header + ".SegHead.code");
        log.debug("found HKTAN response with segcode " + segCode);
        if (this.process == KnownTANProcess.PROCESS2_STEP2 && this.scaJob != null) {
            HBCIRetVal w3040 = KnownReturncode.W3040.searchReturnValue(msgstatus.segStatus.getWarnings());
            if (this.toInsCode(this.getHBCICode(false)).equals(segCode) && w3040 != null) {
                log.debug("found status code 3040, need to repeat task " + this.scaJob.getHBCICode());
                this.redo = this.scaJob;
                this.redo.fillJobResult(msgstatus, msgstatus.findTaskSegment());
            }
            if (this.toInsCode(this.scaJob.getHBCICode()).equals(segCode)) {
                log.debug("this is a response segment for the original task - storing results in the original job");
                this.scaJob.extractResults(msgstatus, header, idx);
            }
            return;
        }
        String orderref = result.get(header + ".orderref");
        String hhdUc = result.get(header + ".challenge_hhd_uc");
        String challenge = result.get(header + ".challenge");
        HHDVersion hhd = HHDVersion.find(this.passport.getCurrentSecMechInfo());
        this.passport.getCallback().tanChallengeCallback(orderref, challenge, hhdUc, hhd.getType());
    }

    private String toInsCode(String hbciCode) {
        return new StringBuffer(hbciCode).replace(1, 2, "I").toString();
    }

    @Override
    public AbstractHBCIJob redo() {
        return this.redo;
    }
}

