/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValidateXMLGVTemplate {
    private static void validateRefs(Element sfelem, List<String> deflist) {
        String sfname = sfelem.getAttribute("id");
        NodeList refs = sfelem.getElementsByTagName("SEG");
        int l = refs.getLength();
        for (int i = 0; i < l; ++i) {
            Element ref = (Element)refs.item(i);
            String refid = ref.getAttribute("type");
            if (deflist.remove(refid)) continue;
            System.out.println("warning: in SF '" + sfname + "': referenced SEG '" + refid + "' does not exist");
        }
        if (deflist.size() != 0) {
            Iterator<String> i = deflist.iterator();
            while (i.hasNext()) {
                System.out.println("warning: defined " + sfname + " '" + i.next() + "' not referenced in SF '" + sfname + "'");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setIgnoringComments(true);
        fac.setIgnoringElementContentWhitespace(true);
        fac.setNamespaceAware(false);
        fac.setValidating(false);
        DocumentBuilder builder = fac.newDocumentBuilder();
        File f = new File(args[0]);
        Document doc = builder.parse(f);
        Element root = doc.getDocumentElement();
        NodeList segdefs = root.getElementsByTagName("SEGdef");
        int l = segdefs.getLength();
        ArrayList<CallSite> seen = new ArrayList<CallSite>();
        ArrayList<String> gvs = new ArrayList<String>();
        ArrayList<String> gvrs = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < l; ++i) {
            Element segdef = (Element)segdefs.item(i);
            String segdefid = segdef.getAttribute("id");
            String segcode = null;
            String segversion = null;
            NodeList values = segdef.getElementsByTagName("value");
            int l2 = values.getLength();
            for (int j = 0; j < l2; ++j) {
                Element value = (Element)values.item(j);
                String path = value.getAttribute("path");
                if (path.equals("SegHead.code")) {
                    segcode = value.getFirstChild().getNodeValue();
                    continue;
                }
                if (!path.equals("SegHead.version")) continue;
                segversion = value.getFirstChild().getNodeValue();
            }
            if (segcode == null || segversion == null) {
                System.out.println("warning: SEGdef with id " + segdefid + " has no segcode or no segversion");
                segcode = "";
                segversion = "";
            } else {
                String key = segcode + ":" + segversion;
                if (seen.contains(key)) {
                    System.out.println("warning: segment " + key + " appears more than once");
                } else {
                    seen.add((CallSite)((Object)key));
                }
            }
            if (segdefid.endsWith("Res" + segversion)) {
                gvrs.add(segdefid);
                continue;
            }
            if (segdefid.endsWith("Par" + segversion)) {
                params.add(segdefid);
                continue;
            }
            gvs.add(segdefid);
        }
        ValidateXMLGVTemplate.validateRefs(doc.getElementById("GV"), gvs);
        ValidateXMLGVTemplate.validateRefs(doc.getElementById("GVRes"), gvrs);
        ValidateXMLGVTemplate.validateRefs(doc.getElementById("Params"), params);
    }
}

