/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AbstractShowLowlevelData {
    protected static void showData(String gvname, Document document, int minLevel) {
        int len = gvname.length();
        int versionpos = -1;
        for (int i = len - 1; i >= 0; --i) {
            char ch = gvname.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            versionpos = i + 1;
            break;
        }
        System.out.println("jobname:" + gvname.substring(0, versionpos) + " version:" + gvname.substring(versionpos));
        Element gvdef = document.getElementById(gvname);
        NodeList gvcontent = gvdef.getChildNodes();
        len = gvcontent.getLength();
        boolean first = true;
        for (int i = 0; i < len; ++i) {
            Node contentref = gvcontent.item(i);
            if (contentref.getNodeType() != 1) continue;
            if (first) {
                first = false;
                continue;
            }
            AbstractShowLowlevelData.displayContentRef("", (Element)contentref, document, 2, 0, minLevel);
        }
    }

    protected static void displayContentRef(String path, Element ref, Document document, int indent, int currentLevel, int minLevel) {
        if (ref.getAttribute("type").length() != 0) {
            StringBuffer spaces = new StringBuffer();
            for (int i = 0; i < indent; ++i) {
                spaces.append(" ");
            }
            if (ref.getNodeName().equals("DE")) {
                if (currentLevel >= minLevel) {
                    String name = ref.getAttribute("name");
                    String datatype = ref.getAttribute("type");
                    String minlen = ref.getAttribute("minsize");
                    String maxlen = ref.getAttribute("maxsize");
                    int minnum = 1;
                    int maxnum = 1;
                    String st = ref.getAttribute("minnum");
                    if (st.length() != 0) {
                        minnum = Integer.parseInt(st);
                    }
                    if ((st = ref.getAttribute("maxnum")).length() != 0) {
                        maxnum = Integer.parseInt(st);
                    }
                    System.out.println(spaces + AbstractShowLowlevelData.pathWithDot(path) + name + ":" + datatype + (String)(minlen.length() != 0 ? " min:" + minlen : "") + (String)(maxlen.length() != 0 ? " max:" + maxlen : "") + " {" + minnum + "," + maxnum + "}");
                }
            } else {
                Object nextPath = path;
                int nextIndent = indent;
                if (currentLevel >= minLevel) {
                    String name = ref.getAttribute("name");
                    if (name.length() == 0) {
                        name = ref.getAttribute("type");
                    }
                    int minnum = 1;
                    int maxnum = 1;
                    String st = ref.getAttribute("minnum");
                    if (st.length() != 0) {
                        minnum = Integer.parseInt(st);
                    }
                    if ((st = ref.getAttribute("maxnum")).length() != 0) {
                        maxnum = Integer.parseInt(st);
                    }
                    System.out.println(spaces + "GROUP:" + name + " {" + minnum + "," + maxnum + "}");
                    nextIndent += 2;
                    nextPath = AbstractShowLowlevelData.pathWithDot(path) + name;
                }
                Element def = document.getElementById(ref.getAttribute("type"));
                NodeList defcontent = def.getChildNodes();
                int len = defcontent.getLength();
                for (int i = 0; i < len; ++i) {
                    Node content = defcontent.item(i);
                    if (content.getNodeType() != 1) continue;
                    AbstractShowLowlevelData.displayContentRef((String)nextPath, (Element)content, document, nextIndent, currentLevel + 1, minLevel);
                }
            }
        }
    }

    protected static void showData(String gvname, Document document) {
        AbstractShowLowlevelData.showData(gvname, document, 0);
    }

    protected static String pathWithDot(String path) {
        return path.length() == 0 ? path : path + ".";
    }
}

