/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.Base64;
import org.kapott.hbci.comm.CommPinTan;

public class QRCode {
    private String mimetype = null;
    private String text = null;
    private byte[] image = null;

    public QRCode(String hhd, String msg) throws Exception {
        byte[] data;
        byte[] byArray = data = hhd != null && hhd.length() > 0 ? hhd.getBytes(CommPinTan.ENCODING) : null;
        if (data != null && data.length > 100) {
            int offset = 0;
            byte[] b = new byte[2];
            System.arraycopy(data, offset, b, 0, 2);
            int len = Integer.parseInt(this.decode(b));
            b = new byte[len];
            System.arraycopy(data, offset += 2, b, 0, len);
            this.mimetype = new String(b, CommPinTan.ENCODING);
            offset += len;
            int len2 = data.length - (offset += 2);
            byte[] b2 = new byte[len2];
            System.arraycopy(data, offset, b2, 0, len2);
            this.image = b2;
            this.text = msg;
            return;
        }
        if (msg != null) {
            msg = msg.trim();
        }
        if (msg == null || msg.length() == 0) {
            throw new Exception("invalid QR code");
        }
        String code = msg;
        code = code.replaceAll("[\\n\\t\\r ]", "");
        int t1Start = code.indexOf("CHLGUC");
        int t2Start = code.indexOf("CHLGTEXT");
        if (t1Start == -1 || t2Start == -1 || t2Start <= t1Start) {
            throw new Exception("invalid QR code");
        }
        code = code.substring(0, t2Start);
        code = code.substring(t1Start);
        code = code.substring(10);
        this.image = Base64.getDecoder().decode(code.getBytes(CommPinTan.ENCODING));
        if (this.image.length > 4 && (this.image[0] & 0xFF) == 137 && (this.image[1] & 0xFF) == 80 && (this.image[2] & 0xFF) == 78 && (this.image[3] & 0xFF) == 71) {
            this.mimetype = "image/png";
        }
        int t1Start2 = msg.indexOf("CHLGTEXT");
        this.text = msg.substring(t1Start2 + 12);
    }

    public static QRCode tryParse(String hhd, String msg) {
        try {
            return new QRCode(hhd, msg);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String decode(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString(bytes[i], 10));
        }
        return sb.toString();
    }

    public byte[] getImage() {
        return this.image;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getMessage() {
        return this.text;
    }
}

