/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import org.kapott.hbci.comm.CommPinTan;

public class MatrixCode {
    private String mimetype = null;
    private byte[] image = null;

    public MatrixCode(String data) throws Exception {
        this(data != null ? data.getBytes(CommPinTan.ENCODING) : null);
    }

    public MatrixCode(byte[] data) throws Exception {
        if (data == null || data.length < 100) {
            throw new Exception("invalid matrix code");
        }
        int offset = 0;
        byte[] b = new byte[2];
        System.arraycopy(data, offset, b, 0, 2);
        int len = Integer.parseInt(this.decode(b));
        b = new byte[len];
        System.arraycopy(data, offset += 2, b, 0, len);
        this.mimetype = new String(b, CommPinTan.ENCODING);
        offset += len;
        int len2 = data.length - (offset += 2);
        byte[] b2 = new byte[len2];
        System.arraycopy(data, offset, b2, 0, len2);
        this.image = b2;
    }

    public static MatrixCode tryParse(String data) {
        try {
            return new MatrixCode(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String decode(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString(bytes[i], 10));
        }
        return sb.toString();
    }

    public byte[] getImage() {
        return this.image;
    }

    public String getMimetype() {
        return this.mimetype;
    }
}

